/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.util.UUID;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.After;
import org.junit.Before;

@ArchiveType(value=JavaArchive.class)
public class JavaArchiveImplTestCase
extends DynamicContainerTestBase<JavaArchive> {
    private static final Path PATH_MANIFEST = new BasicPath("META-INF");
    private static final Path PATH_CLASS = new BasicPath("/");
    private static final Path PATH_RESOURCE = new BasicPath();
    private JavaArchive archive;

    @Before
    public void createArchive() {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected JavaArchive getArchive() {
        return this.archive;
    }

    protected JavaArchive createNewArchive() {
        return (JavaArchive)Archives.create((String)(UUID.randomUUID().toString() + ".jar"), JavaArchive.class);
    }

    @Override
    protected ResourceContainer<JavaArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<JavaArchive> getClassContainer() {
        return this.getArchive();
    }

    @Override
    protected ManifestContainer<JavaArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected LibraryContainer<JavaArchive> getLibraryContainer() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }

    @Override
    protected Path getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected Path getClassPath() {
        return PATH_CLASS;
    }

    @Override
    protected Path getLibraryPath() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }
}

