/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.SpecializedBase;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.container.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class ContainerBase<T extends Archive<T>>
extends SpecializedBase
implements Archive<T>,
ManifestContainer<T>,
ResourceContainer<T>,
ClassContainer<T>,
LibraryContainer<T> {
    private final Archive<?> archive;
    private final Class<T> actualType;

    protected ContainerBase(Class<T> actualType, Archive<?> archive) {
        Validate.notNull(actualType, "ActualType should be specified");
        Validate.notNull(archive, "Archive should be specified");
        this.actualType = actualType;
        this.archive = archive;
    }

    public T add(Archive<?> archive, Path path) {
        this.archive.add(archive, path);
        return this.covarientReturn();
    }

    public T add(Asset asset, Path target) throws IllegalArgumentException {
        this.archive.add(asset, target);
        return this.covarientReturn();
    }

    public T add(Asset asset, Path path, String name) {
        this.archive.add(asset, path, name);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        this.archive.merge(source);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, Path path) throws IllegalArgumentException {
        this.archive.merge(source, path);
        return this.covarientReturn();
    }

    public T add(Asset asset, String name) {
        this.archive.add(asset, name);
        return this.covarientReturn();
    }

    public boolean contains(Path path) {
        return this.archive.contains(path);
    }

    public boolean delete(Path path) {
        return this.archive.delete(path);
    }

    public Asset get(Path path) {
        return this.archive.get(path);
    }

    public Asset get(String path) throws IllegalArgumentException {
        return this.archive.get(path);
    }

    public Map<Path, Asset> getContent() {
        return this.archive.getContent();
    }

    public String getName() {
        return this.archive.getName();
    }

    public String toString(boolean verbose) {
        return this.archive.toString(verbose);
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    protected abstract Path getManinfestPath();

    public final T setManifest(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setManifest(new ClassLoaderAsset(resourceName));
    }

    public T setManifest(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest(new FileAsset(resource));
    }

    public T setManifest(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest(new UrlAsset(resource));
    }

    public T setManifest(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(resource, "MANIFEST.FM");
    }

    public final T addManifestResource(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addManifestResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addManifestResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addManifestResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addManifestResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addManifestResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource(resource, (Path)new BasicPath(target));
    }

    public T addManifestResource(String resourceName, Path target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addManifestResource(File resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new FileAsset(resource), target);
    }

    public T addManifestResource(URL resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addManifestResource(Asset resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getManinfestPath(), target);
        return this.add(resource, (Path)location);
    }

    protected abstract Path getResourcePath();

    public final T addResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public final T addResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource((Asset)new FileAsset(resource), resource.getName());
    }

    public final T addResource(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new FileAsset(resource), target);
    }

    public T addResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new UrlAsset(resource), target);
    }

    public T addResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource(resource, (Path)new BasicPath(target));
    }

    public T addResource(String resourceName, Path target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addResource(String resourceName, Path target, ClassLoader classLoader) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(classLoader, "ClassLoader should be specified");
        return this.addResource((Asset)new ClassLoaderAsset(resourceName, classLoader), target);
    }

    public T addResource(File resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new FileAsset(resource), target);
    }

    public T addResource(URL resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addResource((Asset)new UrlAsset(resource), target);
    }

    public T addResource(Asset resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getResourcePath(), target);
        return this.add(resource, (Path)location);
    }

    protected abstract Path getClassesPath();

    public T addClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Clazz must be specified");
        return this.addClasses(clazz);
    }

    public T addClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNull(classes, "Classes must be specified");
        for (Class<?> clazz : classes) {
            ClassAsset resource = new ClassAsset(clazz);
            BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            this.add((Asset)resource, (Path)location);
        }
        return this.covarientReturn();
    }

    public T addPackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Pack must be specified");
        return this.addPackages(false, pack);
    }

    public T addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(packages, "Packages must be specified");
        for (Package pack : packages) {
            URLPackageScanner scanner = new URLPackageScanner(pack, recursive, SecurityActions.getThreadContextClassLoader());
            Set<Class<?>> classes = scanner.getClasses();
            for (Class<?> clazz : classes) {
                ClassAsset asset = new ClassAsset(clazz);
                BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
                this.add((Asset)asset, (Path)location);
            }
        }
        return this.covarientReturn();
    }

    protected abstract Path getLibraryPath();

    public T addLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getLibraryPath());
    }

    public T addLibrary(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addLibrary(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), resource.getName());
    }

    public T addLibrary(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addLibrary(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), target);
    }

    public T addLibrary(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addLibrary(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary(resource, (Path)new BasicPath(target));
    }

    public T addLibrary(String resourceName, Path target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addLibrary(File resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new FileAsset(resource), target);
    }

    public T addLibrary(URL resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addLibrary((Asset)new UrlAsset(resource), target);
    }

    public T addLibrary(Asset resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getLibraryPath(), target);
        return this.add(resource, (Path)location);
    }

    public T addLibraries(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "ResourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addLibrary(resourceName);
        }
        return this.covarientReturn();
    }

    public T addLibraries(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "Resources must be specified");
        for (File resource : resources) {
            this.addLibrary(resource);
        }
        return this.covarientReturn();
    }

    public T addLibraries(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        for (Archive<?> archive : archives) {
            this.addLibrary(archive);
        }
        return this.covarientReturn();
    }

    protected T covarientReturn() {
        return (T)((Archive)this.getActualClass().cast(this));
    }

    protected Class<T> getActualClass() {
        return this.actualType;
    }
}

