/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.Paths;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;
import org.junit.Test;

public class ArchivesTestCase {
    private static boolean extensionLoaderCalled = false;

    @Test
    public void shouldBeAbleToCreateANewArchive() throws Exception {
        String archiveName = "test.war";
        this.reset();
        JavaArchive archive = (JavaArchive)Archives.create((String)archiveName, JavaArchive.class);
        Assert.assertNotNull((String)"A archive should have been created", (Object)archive);
        Assert.assertEquals((String)"Should have the same name as given imput", (String)archiveName, (String)archive.getName());
    }

    @Test
    public void shouldBeAbleToAddOverride() throws Exception {
        this.reset();
        Archives.addExtensionOverride(JavaArchive.class, MockJavaArchiveImpl.class);
        JavaArchive archive = (JavaArchive)Archives.create((String)"test.jar", JavaArchive.class);
        Assert.assertEquals((String)"Should have overridden normal JavaArchive impl", MockJavaArchiveImpl.class, archive.getClass());
    }

    @Test
    public void shouldBeAbleToSetExtensionLoader() throws Exception {
        this.reset();
        Archives.setExtensionLoader((ExtensionLoader)new ExtensionLoader(){

            public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
                extensionLoaderCalled = true;
                return (T)new JavaArchiveImpl(baseArchive);
            }

            public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
                return null;
            }
        });
        Archives.create((String)"test.jar", JavaArchive.class);
        Assert.assertTrue((String)"Specified ExtensionLoader should have been used", (boolean)extensionLoaderCalled);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotBeAbleToSetExtensionLoaderNull() throws Exception {
        this.reset();
        Archives.setExtensionLoader(null);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToSetExtensionLoaderAfterInitialized() throws Exception {
        this.reset();
        Archives.create((String)"test.jar", JavaArchive.class);
        Archives.setExtensionLoader((ExtensionLoader)new ExtensionLoader(){

            public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
                return null;
            }

            public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
                return null;
            }
        });
    }

    private void reset() throws Exception {
        Method method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws Exception {
                Method method = Archives.class.getDeclaredMethod("resetState", new Class[0]);
                method.setAccessible(true);
                return method;
            }
        });
        method.invoke(null, new Object[0]);
    }

    public static class MockJavaArchiveImpl
    extends ContainerBase<JavaArchive>
    implements JavaArchive {
        public MockJavaArchiveImpl(Archive<?> archive) {
            super(JavaArchive.class, archive);
        }

        protected Path getClassesPath() {
            return Paths.root();
        }

        protected Path getLibraryPath() {
            return Paths.root();
        }

        protected Path getManinfestPath() {
            return Paths.root();
        }

        protected Path getResourcePath() {
            return Paths.root();
        }

        public String toString(Formatter formatter) throws IllegalArgumentException {
            return formatter.format((Archive)this);
        }
    }
}

