/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.exporter.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;
import org.junit.Test;

public class ExplodedExporterTestCase
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ExplodedExporterTestCase.class.getName());

    @Test
    public void testExportExploded() throws Exception {
        log.info("testExportExploded");
        File tempDirectory = this.createTempDirectory("testExportExploded");
        Archive<?> archive = this.createArchiveWithAssets();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tempDirectory);
        Assert.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assert.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        this.assertAssetInExploded(explodedDirectory, PATH_ONE, ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportNestedExploded() throws Exception {
        log.info("testExportNestedExploded");
        File tempDirectory = this.createTempDirectory("testExportNestedExploded");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tempDirectory);
        Assert.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assert.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        BasicPath nestedArchivePath = new BasicPath("nestedArchive.jar");
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePath, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePath, PATH_TWO), ASSET_TWO);
        BasicPath nestedArchivePathTwo = new BasicPath(NESTED_PATH, "nestedArchive2.jar");
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePathTwo, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePathTwo, PATH_TWO), ASSET_TWO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExportExplodedRequiresBaseDirectroy() throws Exception {
        log.info("testExportExplodedRequiresBaseDirectroy");
        ((ExplodedExporter)Archives.create((String)"test.jar", ExplodedExporter.class)).exportExploded(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExportExplodedRequiresExistingDirectory() throws Exception {
        log.info("testExportExplodedRequiresExisitingDirectroy");
        File directory = this.getNonexistantDirectory();
        ((ExplodedExporter)Archives.create((String)"test.jar", ExplodedExporter.class)).exportExploded(directory);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExportExplodedRequiresValidDirectory() throws Exception {
        log.info("testExportExplodedRequiresValidDirectory");
        File nonDirectory = new File(this.getTarget(), "tempFile.txt");
        ((ExplodedExporter)Archives.create((String)"test.jar", ExplodedExporter.class)).exportExploded(nonDirectory);
    }

    @Test(expected=ArchiveExportException.class)
    public void testExportExplodedOutpuDirCreationFails() throws Exception {
        log.info("testExportExplodedOutpuDirCreationFails");
        File directory = this.createTempDirectory("testExportExplodedOutpuDirCreationFails");
        directory.deleteOnExit();
        ((ExplodedExporter)Archives.create((String)"test/testArchive.jar", ExplodedExporter.class)).exportExploded(directory);
    }

    @Test(expected=ArchiveExportException.class)
    public void testExportExplodedThrowsExceptionOnAssetWrite() throws Exception {
        log.info("testExportExplodedThrowsExceptionOnAssetWrite");
        Archive<?> archive = this.createArchiveWithAssets();
        archive.add(new Asset(){

            public InputStream openStream() {
                throw new RuntimeException("Mock Esception getting Stream");
            }
        }, (Path)new BasicPath("badAsset"));
        File directory = this.createTempDirectory("testExportExplodedThrowsExceptionOnAssetWrite");
        ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(directory);
    }

    @Test
    public void testShouldBeAbleToUseExistingDirectoryAsParent() throws Exception {
        Archive<?> archive = this.createArchiveWithAssets();
        File existingParentFolder = new File("target/");
        existingParentFolder.mkdirs();
        Assert.assertTrue((String)"Internal error, the directory need to exist for test case to work", (boolean)existingParentFolder.exists());
        File archiveFolder = new File(existingParentFolder, archive.getName());
        archiveFolder.mkdirs();
        Assert.assertTrue((String)"Internal error, the directory need to exist for test case to work", (boolean)existingParentFolder.exists());
        ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(existingParentFolder);
        Assert.assertTrue((String)"A subfolder with archive name should have been created", (boolean)new File(existingParentFolder, archive.getName()).exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExportExplodedOutpuDirIsAFile() throws Exception {
        log.info("testExportExplodedOutpuDirIsAFile");
        File directory = this.createTempDirectory("testExportExplodedOutpuDirIsAFile");
        File existingFile = new File(directory, "testArchive.jar");
        boolean created = existingFile.createNewFile();
        IOUtil.copyWithClose((InputStream)new ByteArrayInputStream("test-test".getBytes()), (OutputStream)new FileOutputStream(existingFile));
        Assert.assertEquals((String)"Could not create test file", (Object)true, (Object)created);
        ((ExplodedExporter)this.createArchiveWithAssets().as(ExplodedExporter.class)).exportExploded(directory);
    }

    private File getNonexistantDirectory() {
        File directory = new File(this.getTarget(), "someNonExistentDirectory");
        if (directory.exists()) {
            TestIOUtil.deleteDirectory(directory);
        }
        Assert.assertTrue((String)("Precondition Failure: Directory should not exist: " + directory), (!directory.exists() ? 1 : 0) != 0);
        return directory;
    }

    private void assertAssetInExploded(File explodedDirectory, Path path, Asset asset) throws FileNotFoundException {
        File assetFile = new File(explodedDirectory, path.get());
        Assert.assertNotNull((Object)assetFile);
        Assert.assertTrue((boolean)assetFile.exists());
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        FileInputStream inputStream = new FileInputStream(assetFile);
        byte[] actualContents = IOUtil.asByteArray((InputStream)inputStream);
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }
}

