/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.Paths;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.Assert;
import org.junit.Test;

public class PathUtilTestCase {
    private static final Logger log = Logger.getLogger(PathUtilTestCase.class.getName());

    @Test
    public void testRemovePrecedingSlash() {
        log.info("testRemovePrecedingSlash");
        String precedingSlash = "/test/something";
        String expected = "/test/something".substring(1);
        String result = PathUtil.optionallyRemovePrecedingSlash((String)"/test/something");
        Assert.assertEquals((String)"Call to remove preceding slash should return everything in input except the first slash", (Object)expected, (Object)result);
    }

    @Test
    public void testRemovePrecedingSlashWithNoPrecedingSlashEqualToInput() {
        log.info("testRemovePrecedingSlash");
        String noPrecedingSlash = "test/something";
        String result = PathUtil.optionallyRemovePrecedingSlash((String)"test/something");
        Assert.assertEquals((String)"Call to remove preceding slash on input with no preceding slash should return equal by value to input", (Object)"test/something", (Object)result);
    }

    @Test
    public void testPrependSlash() {
        log.info("testRemovePrecedingSlash");
        String noPrecedingSlash = "test/something";
        String expected = "/test/something";
        String result = PathUtil.optionallyPrependSlash((String)"test/something");
        Assert.assertEquals((String)"Call to prepend a slash failed", (Object)"/test/something", (Object)result);
    }

    @Test
    public void testNoOpPrependSlash() {
        log.info("testRemovePrecedingSlash");
        String precedingSlash = "/test/something";
        String result = PathUtil.optionallyPrependSlash((String)"/test/something");
        Assert.assertEquals((String)"Call to optionally prepend a slash upon input with slash prefix should return no-op", (Object)"/test/something", (Object)result);
    }

    @Test
    public void testAppendSlash() {
        log.info("testRemovePrecedingSlash");
        String noFollowingSlash = "test/something";
        String expected = "test/something/";
        String result = PathUtil.optionallyAppendSlash((String)"test/something");
        Assert.assertEquals((String)"Call to append a slash failed", (Object)"test/something/", (Object)result);
    }

    @Test
    public void testNoOpAppendSlash() {
        log.info("testRemovePrecedingSlash");
        String followingSlash = "/test/something/";
        String result = PathUtil.optionallyAppendSlash((String)"/test/something/");
        Assert.assertEquals((String)"Call to optionally append a slash upon input with slash suffix should return no-op", (Object)"/test/something/", (Object)result);
    }

    @Test
    public void testAdjustToRelativeDirectoryContext() {
        log.info("testRemovePrecedingSlash");
        String absoulteWithoutTrailingSlash = "/test/something";
        String expected = "/test/something".substring(1) + '/';
        String result = PathUtil.adjustToRelativeDirectoryContext((String)"/test/something");
        Assert.assertEquals((String)"Adjusting to relative form should strip preceding slash and append a trailing one", (Object)expected, (Object)result);
    }

    @Test
    public void testAdjustToAbsoluteDirectoryContext() {
        log.info("testRemovePrecedingSlash");
        String relativeWithoutTrailingSlash = "test/something";
        String expected = "/test/something/";
        String result = PathUtil.adjustToAbsoluteDirectoryContext((String)"test/something");
        Assert.assertEquals((String)"Adjusting to absolute form should prepend preceding slash and append a trailing one", (Object)"/test/something/", (Object)result);
    }

    @Test
    public void testComposeAbsoulteContext() {
        log.info("testComposeAbsoulteContext");
        String base = "something";
        String context = "somethingunder";
        String expected = "/something/somethingunder";
        String result = PathUtil.composeAbsoluteContext((String)"something", (String)"somethingunder");
        Assert.assertEquals((String)"Composing an absolute context from base and context did not succeed", (Object)"/something/somethingunder", (Object)result);
    }

    @Test
    public void testParent() {
        log.info("testParent");
        String rootString = "/";
        String subpathString = "subpath/";
        String contextString = "context";
        String contextWithFollowingSlashString = "context/";
        Path root = Paths.create((String)"/");
        Path subpath = Paths.create((String)"subpath/");
        Path context = Paths.create((Path)subpath, (String)"context");
        BasicPath contextWithFollowingSlash = new BasicPath(subpath, "context/");
        TestCase.assertEquals((String)"The parent of the context path should be equal to the initial subpath", (Object)subpath, (Object)PathUtil.getParent((Path)context));
        TestCase.assertEquals((String)"The parent of the context path with a following slash should be equal to the initial subpath", (Object)subpath, (Object)PathUtil.getParent((Path)contextWithFollowingSlash));
        TestCase.assertEquals((String)"The parent of the subpath should be the root", (Object)root, (Object)PathUtil.getParent((Path)subpath));
        TestCase.assertNull((String)"The parent of the root should be null", (Object)PathUtil.getParent((Path)root));
    }
}

