/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.junit.Assert;
import org.junit.Test;

public class FiltersTestCase {
    @Test
    public void shouldIncludeAll() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includeAll());
        Assert.assertArrayEquals((String)"Should include all paths", (Object[])paths.toArray(), (Object[])filteredPaths.toArray());
    }

    @Test
    public void shouldIncludePathRegExp() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.include((String)".*META-INF.*"));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain metainf", (Object)ArchivePaths.create((String)"/META-INF/"), (Object)filteredPaths.get(0));
    }

    @Test
    public void shouldExcludePathRegExp() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.exclude((String)".*META-INF.*"));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain webinf", (Object)ArchivePaths.create((String)"/WEB-INF/"), (Object)filteredPaths.get(0));
    }

    @Test
    public void shouldIncludeAllClasses() throws Exception {
        ArrayList classes = new ArrayList();
        classes.add(FiltersTestCase.class);
        List<Class<?>> filteredClasses = this.executeFilter(classes, Filters.includeAllClasses());
        Assert.assertArrayEquals((String)"Should include all classes", (Object[])classes.toArray(), (Object[])filteredClasses.toArray());
    }

    private <T> List<T> executeFilter(Class<T> clazz, List<T> items, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            if (!filter.include(item)) continue;
            result.add(item);
        }
        return result;
    }

    private List<Class<?>> executeFilter(List<Class<?>> items, Filter<Class<?>> filter) {
        ArrayList result = new ArrayList();
        for (Class<?> item : items) {
            if (!filter.include(item)) continue;
            result.add(item);
        }
        return result;
    }
}

