/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.Test;

public abstract class DynamicEnterpriseContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    protected abstract ArchivePath getModulePath();

    protected abstract ArchivePath getApplicationPath();

    protected abstract EnterpriseContainer<T> getEnterpriseContainer();

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResource() throws Exception {
        this.getEnterpriseContainer().setApplicationXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLFile() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLURL() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLAsset() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetURL() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetAsset() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetURL() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetAsset() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleResource() throws Exception {
        this.getEnterpriseContainer().addModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleFile() throws Exception {
        this.getEnterpriseContainer().addModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetResource() throws Exception {
        this.getEnterpriseContainer().addModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetURL() throws Exception {
        this.getEnterpriseContainer().addModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetAsset() throws Exception {
        this.getEnterpriseContainer().addModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetResource() throws Exception {
        this.getEnterpriseContainer().addModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetFile() throws Exception {
        this.getEnterpriseContainer().addModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetURL() throws Exception {
        this.getEnterpriseContainer().addModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetAsset() throws Exception {
        this.getEnterpriseContainer().addModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getEnterpriseContainer().addModule(archive);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }
}

