/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.File;
import java.net.URL;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassA;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassParent;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestRunner;
import org.jboss.shrinkwrap.impl.base.test.SecurityActions;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyClassForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyInterfaceForTest;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=ContainerTestRunner.class)
public abstract class DynamicContainerTestBase<T extends Archive<T>>
extends ArchiveTestBase<T> {
    protected abstract ArchivePath getResourcePath();

    protected abstract ResourceContainer<T> getResourceContainer();

    protected abstract ArchivePath getClassPath();

    protected abstract ClassContainer<T> getClassContainer();

    protected abstract ArchivePath getManifestPath();

    protected abstract ManifestContainer<T> getManifestContainer();

    protected abstract ArchivePath getLibraryPath();

    protected abstract LibraryContainer<T> getLibraryContainer();

    protected URL getURLForClassResource(String name) {
        return SecurityActions.getThreadContextClassLoader().getResource(name);
    }

    protected File getFileForClassResource(String name) throws Exception {
        return new File(this.getURLForClassResource(name).toURI());
    }

    protected Asset getAssetForClassResource(String name) {
        return new ClassLoaderAsset(name);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResource() throws Exception {
        this.getManifestContainer().setManifest("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestFile() throws Exception {
        this.getManifestContainer().setManifest(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestURL() throws Exception {
        this.getManifestContainer().setManifest(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestAsset() throws Exception {
        this.getManifestContainer().setManifest(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResource() throws Exception {
        this.getManifestContainer().addManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFile() throws Exception {
        this.getManifestContainer().addManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getManifestContainer().addManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getManifestPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResource() throws Exception {
        this.getManifestContainer().addManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetFile() throws Exception {
        this.getManifestContainer().addManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetURL() throws Exception {
        this.getManifestContainer().addManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetAsset() throws Exception {
        this.getManifestContainer().addManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetResource() throws Exception {
        this.getManifestContainer().addManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetFile() throws Exception {
        this.getManifestContainer().addManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetURL() throws Exception {
        this.getManifestContainer().addManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetAsset() throws Exception {
        this.getManifestContainer().addManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProvider() throws Exception {
        this.getManifestContainer().addServiceProvider(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + DummyInterfaceForTest.class.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceResource() throws Exception {
        this.getResourceContainer().addResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFile() throws Exception {
        this.getResourceContainer().addResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getResourceContainer().addResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getResourcePath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResource() throws Exception {
        this.getResourceContainer().addResource("Test.txt", "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetFile() throws Exception {
        this.getResourceContainer().addResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetURL() throws Exception {
        this.getResourceContainer().addResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetAsset() throws Exception {
        this.getResourceContainer().addResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetResource() throws Exception {
        this.getResourceContainer().addResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetFile() throws Exception {
        this.getResourceContainer().addResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetURL() throws Exception {
        this.getResourceContainer().addResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetAsset() throws Exception {
        this.getResourceContainer().addResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClass() throws Exception {
        this.getClassContainer().addClass(DummyClassA.class);
        this.ensureClassesAdded();
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClasses() throws Exception {
        this.getClassContainer().addClasses(new Class[]{DummyClassA.class});
        this.ensureClassesAdded();
    }

    private void ensureClassesAdded() {
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
        BasicPath expectedPathInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class));
        BasicPath expectedPathInnerClassParent = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassParent.ParentInnerClass.class));
        Assert.assertTrue((String)"Adding a class should also add its inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClass));
        Assert.assertFalse((String)"Adding a class should not add the public inner classes of its parent", (boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClassParent));
        BasicPath expectedPathPrivateInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "Test"));
        BasicPath expectedPathAnonymousInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "1"));
        Assert.assertTrue((String)"Adding a class should also add its private inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathPrivateInnerClass));
        Assert.assertTrue((String)"Adding a class should also add the anonymous inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathAnonymousInnerClass));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqn() throws Exception {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqnAndTccl() throws Exception {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName(), classToAdd.getClassLoader());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackage() throws Exception {
        this.getClassContainer().addPackage(DummyClassA.class.getPackage());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageNonRecursive() throws Exception {
        this.getClassContainer().addPackages(false, new Package[]{DummyClassA.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPakcageRecursiveFiltered() throws Exception {
        this.getClassContainer().addPackages(true, new Filter<Class<?>>(){

            public boolean include(Class<?> clazz) {
                return clazz == DynamicContainerTestBase.class;
            }
        }, new Package[]{DynamicContainerTestBase.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        Assert.assertEquals((String)"Should only be one class added", (int)1, (int)this.numAssets((Archive<?>)this.getArchive()));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResource() throws Exception {
        this.getLibraryContainer().addLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFile() throws Exception {
        this.getLibraryContainer().addLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getLibraryContainer().addLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetResource() throws Exception {
        this.getLibraryContainer().addLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetFile() throws Exception {
        this.getLibraryContainer().addLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetURL() throws Exception {
        this.getLibraryContainer().addLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetAsset() throws Exception {
        this.getLibraryContainer().addLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetResource() throws Exception {
        this.getLibraryContainer().addLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetFile() throws Exception {
        this.getLibraryContainer().addLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetURL() throws Exception {
        this.getLibraryContainer().addLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetAsset() throws Exception {
        this.getLibraryContainer().addLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getLibraryContainer().addLibrary(archive);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibriesResource() throws Exception {
        this.getLibraryContainer().addLibraries(new String[]{"org/jboss/shrinkwrap/impl/base/asset/Test.properties", "org/jboss/shrinkwrap/impl/base/asset/Test2.properties"});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibriesFile() throws Exception {
        this.getLibraryContainer().addLibraries(new File[]{this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test2.properties")});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchive() throws Exception {
        Archive archive = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        this.getLibraryContainer().addLibraries(new Archive[]{archive, archive2});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }
}

