/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationBuilderTestCase {
    private ConfigurationBuilder builder;

    @Before
    public void createDefaultBuilder() {
        this.builder = new ConfigurationBuilder();
    }

    @Test
    public void defaultsExecutorService() {
        this.builder.build();
        ExecutorService service = this.builder.getExecutorService();
        Assert.assertNull((String)("The builder should not default an " + ExecutorService.class.getSimpleName()), (Object)service);
    }

    @Test
    public void defaultsExtensionLoader() {
        this.builder.build();
        ExtensionLoader loader = this.builder.getExtensionLoader();
        Assert.assertNotNull((String)("The builder should default an " + ExtensionLoader.class.getSimpleName()), (Object)loader);
    }

    @Test
    public void allowsUserDefinedExecutorService() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        this.builder.executorService(service).build();
        TestCase.assertEquals((String)("Building should not override the user-supplied " + ExecutorService.class.getSimpleName()), (Object)service, (Object)this.builder.getExecutorService());
    }

    @Test
    public void allowsUserDefinedExtensionLoader() {
        ExtensionLoader loader = new ExtensionLoader(){

            public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
                return null;
            }

            public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
                return null;
            }
        };
        this.builder.extensionLoader(loader).build();
        TestCase.assertEquals((String)("Building should not override the user-supplied " + ExtensionLoader.class.getSimpleName()), (Object)loader, (Object)this.builder.getExtensionLoader());
    }

    public void createsConfiguration() {
        Configuration configuration = this.builder.build();
        ExecutorService service = this.builder.getExecutorService();
        ExtensionLoader loader = this.builder.getExtensionLoader();
        TestCase.assertEquals((String)(ExecutorService.class.getSimpleName() + " in the config does not match that in the builder"), (Object)service, (Object)configuration.getExecutorService());
        TestCase.assertEquals((String)(ExtensionLoader.class.getSimpleName() + " in the config does not match that in the builder"), (Object)loader, (Object)configuration.getExtensionLoader());
    }
}

