/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.junit.Assert;
import org.junit.Test;

public abstract class PathsTestBase {
    private static final Logger log = Logger.getLogger(PathsTestBase.class.getName());

    abstract ArchivePath createPath(String var1);

    abstract ArchivePath createPath(ArchivePath var1, ArchivePath var2);

    abstract ArchivePath createPath(ArchivePath var1, String var2);

    abstract ArchivePath createPath(String var1, String var2);

    @Test
    public void testNullDefaultsToRoot() {
        log.info("testNullDefaultsToRoot");
        ArchivePath path = this.createPath(null);
        String resolved = path.get();
        Assert.assertEquals((String)"Null context should resolve to root path", (Object)String.valueOf('/'), (Object)resolved);
        log.info("null argument resolves to: " + path);
    }

    @Test
    public void testRelativeResolvedToAbsolute() {
        log.info("testRelativeResolvedToAbsolute");
        String relative = "relative";
        ArchivePath path = this.createPath("relative");
        String resolved = path.get();
        String expected = "/relative";
        Assert.assertEquals((String)"Relative paths should resolve to absolute", (Object)"/relative", (Object)resolved);
        log.info("\"relative\" resolves to: " + path);
    }

    @Test
    public void testAbsoluteDirectoryContextPreserved() {
        log.info("testAbsoluteDirectoryContextPreserved");
        String absoluteDir = "/absoluteDir/";
        ArchivePath path = this.createPath("/absoluteDir/");
        String resolved = path.get();
        String expected = "/absoluteDir/";
        Assert.assertEquals((String)"Absolute directory contexts should be preserved", (Object)"/absoluteDir/", (Object)resolved);
        log.info("\"/absoluteDir/\" resolves to: " + path);
    }

    @Test
    public void testBasePathAndRelativeContext() {
        log.info("testBasePathAndRelativeContext");
        String base = "base";
        ArchivePath basePath = this.createPath("base");
        String context = "context";
        ArchivePath contextPath = this.createPath("context");
        ArchivePath path = this.createPath(basePath, contextPath);
        String resolved = path.get();
        String expected = "/base/context";
        Assert.assertEquals((String)"Context under base should resolve to relative", (Object)"/base/context", (Object)resolved);
        log.info("\"context\" under base " + basePath + " resolves to: " + path);
    }

    @Test
    public void testBasePathAndRelativeContextAsString() {
        log.info("testBasePathAndRelativeContextAsString");
        String base = "base";
        ArchivePath basePath = this.createPath("base");
        String context = "context";
        ArchivePath path = this.createPath(basePath, "context");
        String resolved = path.get();
        String expected = "/base/context";
        Assert.assertEquals((String)"Context under base should resolve to relative", (Object)"/base/context", (Object)resolved);
        log.info("\"context\" under base " + basePath + " resolves to: " + path);
    }

    @Test
    public void testBasePathAsStringAndRelativeContextAsString() {
        log.info("testBasePathAsStringAndRelativeContextAsString");
        String base = "base";
        String context = "context";
        ArchivePath path = this.createPath("base", "context");
        String resolved = path.get();
        String expected = "/base/context";
        Assert.assertEquals((String)"Context under base should resolve to relative", (Object)"/base/context", (Object)resolved);
        log.info("\"context\" under base \"base\" resolves to: " + path);
    }

    @Test
    public void testHashCode() {
        log.info("testHashCode");
        String context = "context";
        ArchivePath path1 = this.createPath("context");
        ArchivePath path2 = this.createPath("context");
        int hash1 = path1.hashCode();
        int hash2 = path2.hashCode();
        Assert.assertEquals((String)"Paths with the same context should have equal hash codes", (long)hash1, (long)hash2);
        log.info("Both " + path1 + " and " + path2 + " have hashCode: " + hash1);
    }

    @Test
    public void testEquals() {
        log.info("testEquals");
        String context = "context";
        String contextWithFollowingSlash = "context/";
        ArchivePath path1 = this.createPath("context");
        ArchivePath path2 = this.createPath("context");
        ArchivePath pathWithFollowingSlash = this.createPath("context/");
        Assert.assertEquals((String)"Paths with same context should be equal by value", (Object)path1, (Object)path2);
        Assert.assertEquals((String)"Paths with same context (regardless of following slash) should be equal by value", (Object)path1, (Object)pathWithFollowingSlash);
        log.info(path1 + " equal by value to " + path2);
    }

    @Test
    public void testNotEqual() {
        log.info("testEquals");
        String context1 = "context1";
        String context2 = "context2";
        ArchivePath path1 = this.createPath("context1");
        ArchivePath path2 = this.createPath("context2");
        Assert.assertTrue((String)"Paths with different contexts should not be equal by value", (!path1.equals(path2) ? 1 : 0) != 0);
        log.info(path1 + " not equal by value to " + path2);
    }
}

