/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.After;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveTestBase<T extends Archive<T>> {
    public static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    public static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";

    protected abstract T getArchive();

    protected abstract Archive<T> createNewArchive();

    @After
    public void ls() {
        T archive = this.getArchive();
        System.out.println("test@jboss:/$ ls -l " + archive.getName());
        System.out.println(archive.toString(true));
    }

    @Test
    public void testAddAssetToPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        Assert.assertTrue((String)("Asset should be placed on " + location.get()), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, (ArchivePath)new BasicPath("/", "Test.properties"));
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, location.get());
        Assert.assertTrue((String)("Asset should be placed on " + new BasicPath("/", "test.properties")), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddWithStringPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPathRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, "/Test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithArchivePathAndName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ArchivePath location = ArchivePaths.root();
        archive.add((Asset)asset, location, "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testAddAssetWithStringPathAndName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "/", "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testAddAssetWithNameRequiresArchivePath() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (ArchivePath)null, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAssetWithNameRequiresStringPath() throws Exception {
        T archive = this.getArchive();
        archive.add((Asset)EmptyAsset.INSTANCE, (String)null, "childPath");
    }

    @Test
    public void testAddAssetWithNameRequiresName() throws Exception {
        T archive = this.getArchive();
        BasicPath path = new BasicPath("/", "Test.properties");
        String resource = NAME_TEST_PROPERTIES;
        try {
            archive.add((Asset)new ClassLoaderAsset(NAME_TEST_PROPERTIES), (ArchivePath)path, null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresAsset() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        BasicPath path = new BasicPath("/", "Test.properties");
        try {
            archive.add(null, (ArchivePath)path, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNamedAsset() throws Exception {
        T archive = this.getArchive();
        String testName = "check.properties";
        ClassLoaderAsset testAsset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        NamedAsset namedAsset = new NamedAsset((Asset)testAsset){
            final /* synthetic */ Asset val$testAsset;
            {
                this.val$testAsset = asset;
            }

            public String getName() {
                return "check.properties";
            }

            public InputStream openStream() {
                return this.val$testAsset.openStream();
            }
        };
        archive.add(namedAsset);
        Assert.assertTrue((String)"Asset should be placed on check.properties", (boolean)archive.contains("check.properties"));
    }

    @Test
    public void testAddEmptyDirectories() throws Exception {
        T archive = this.getArchive();
        ArchivePath path1 = ArchivePaths.create((String)"path/to/dir");
        ArchivePath path2 = ArchivePaths.create((String)"path/to/dir2");
        ArchivePath path3 = ArchivePaths.create((String)"path/to");
        archive.addAsDirectories(new ArchivePath[]{path1, path2, path3});
        String message = "Should be able to add directory: ";
        TestCase.assertTrue((String)("Should be able to add directory: " + path1), (boolean)archive.contains(path1));
        TestCase.assertTrue((String)("Should be able to add directory: " + path2), (boolean)archive.contains(path2));
        TestCase.assertTrue((String)("Should be able to add directory: " + path3), (boolean)archive.contains(path3));
    }

    @Test
    public void testContainsPathAsString() {
        T archive = this.getArchive();
        String path = "testpath";
        archive.add((Asset)EmptyAsset.INSTANCE, "testpath");
        Assert.assertTrue((String)"Archive should contain the path added", (boolean)archive.contains("testpath"));
    }

    @Test
    public void testContainsPathAsArchivePath() {
        T archive = this.getArchive();
        ArchivePath path = ArchivePaths.create((String)"testpath");
        archive.add((Asset)EmptyAsset.INSTANCE, path);
        Assert.assertTrue((String)"Archive should contain the path added", (boolean)archive.contains(path));
    }

    @Test
    public void testDeleteAsset() throws Exception {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(resource);
        archive.add((Asset)asset, (ArchivePath)location);
        Assert.assertTrue((boolean)archive.contains((ArchivePath)location));
        Assert.assertEquals((String)"Successfully deleting an Asset should return the removed Node", (Object)asset, (Object)archive.delete((ArchivePath)location).getAsset());
        Assert.assertFalse((String)("There should no longer be an asset at: " + location.get() + " after deleted"), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testDeleteMissingAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        Assert.assertNull((String)"Deleting a non-existent Asset should return null", (Object)archive.delete((ArchivePath)location));
    }

    @Test
    public void testDeleteAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.delete(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get((ArchivePath)location);
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAssetWithString() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get(location.get());
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetWithStringRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAsTypeString() throws Exception {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, child.getName());
        Assert.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeArchivePath() throws Exception {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, ArchivePaths.create((String)child.getName()));
        Assert.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeWithFilter() throws Exception {
        GenericArchive child1 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child2 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child3 = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"SHOULD_NOT_BE_FOUND.xxx");
        Archive archive = this.getArchive().add((Archive)child1, "/", ZipExporter.class).add((Archive)child2, "/", ZipExporter.class).add((Archive)child3, "/", ZipExporter.class);
        Collection matches = archive.getAsType(GenericArchive.class, Filters.include((String)".*\\.jar"));
        Assert.assertNotNull((Object)matches);
        Assert.assertEquals((String)"Two archives should be found", (int)2, (int)matches.size());
        for (GenericArchive match : matches) {
            if (match.getName().equals(child1.getName()) || match.getName().equals(child2.getName())) continue;
            Assert.fail((String)("Wrong archive found, " + match.getName() + ". Expected " + child1.getName() + " or " + child2.getName()));
        }
    }

    @Test
    public void testToGetContent() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent();
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertTrue((String)("Asset should existing in content with key: " + location.get()), (boolean)this.compareAssets((Asset)asset, node1.getAsset()));
        Assert.assertTrue((String)("Asset should existing in content with key: " + locationTwo.get()), (boolean)this.compareAssets((Asset)assetTwo, node2.getAsset()));
    }

    @Test
    public void testToGetContentFiltered() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent(Filters.include((String)".*test2.*"));
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertEquals((String)"Only 1 Asset should have been included", (int)1, (int)content.size());
        Assert.assertNull((String)"Should not be included in content", (Object)node1);
        Assert.assertNotNull((String)"Should be included in content", (Object)node2);
    }

    @Test
    public void testAddArchiveToPathRequireArchivePath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (ArchivePath)null, ZipExporter.class);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddArchiveToPathRequireStringPath() throws Exception {
        T archive = this.getArchive();
        archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (String)null, ZipExporter.class);
    }

    @Test
    public void testAddArchiveToPathRequireArchive() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)null, ArchivePaths.root(), ZipExporter.class);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddAssetOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        ArchivePath locationTwo = ArchivePaths.create((String)"/test.properties/somewhere");
        archive.add((Asset)assetTwo, locationTwo);
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddDirectoryOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/somewhere/test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        archive.addAsDirectory("/somewhere/test.properties/test");
    }

    @Test
    public void testMergeRequiresSource() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMerge() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive);
        Node node1 = archive.get((ArchivePath)location);
        Node node2 = archive.get((ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node1.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node2.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToStringPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation);
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPathWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeToStringPathWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        Assert.assertTrue((String)("Asset should have been added to path: " + locationTwo.get()), (boolean)this.compareAssets(archive.get((ArchivePath)locationTwo).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeToPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(this.createNewArchive(), (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddArchiveToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        Node node = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Asset should have been added to path: " + expectedPath.get()), (Object)node);
        Assert.assertTrue((String)("An instance of ArchiveAsset should have been added to path: " + expectedPath.get()), (boolean)(node.getAsset() instanceof ArchiveAsset));
        ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(node.getAsset());
        Archive nestedArchive = archiveAsset.getArchive();
        Assert.assertEquals((String)"Nested Archive should be same archive that was added", sourceArchive, (Object)nestedArchive);
    }

    @Test
    public void testNestedArchiveContains() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        sourceArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath archivePath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)archivePath, "test.properties");
        Assert.assertTrue((String)"Nested archive assets should be verified through a fully qualified path", (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testNestedArchiveGet() throws Exception {
        T archive = this.getArchive();
        Archive<T> nestedArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(nestedArchive, (ArchivePath)baseLocation, ZipExporter.class);
        Archive<T> nestedNestedArchive = this.createNewArchive();
        nestedArchive.add(nestedNestedArchive, ArchivePaths.root(), ZipExporter.class);
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        nestedNestedArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath nestedArchivePath = new BasicPath((ArchivePath)baseLocation, nestedArchive.getName());
        BasicPath nestedNestedArchivePath = new BasicPath((ArchivePath)nestedArchivePath, nestedNestedArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)nestedNestedArchivePath, "test.properties");
        Node nestedNode = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Nested archive asset should be available through partent archive at " + expectedPath.get()), (Object)nestedNode.getAsset());
    }

    private boolean compareAssets(Asset one, Asset two) throws IllegalArgumentException {
        Validate.notNull((Object)one, (String)"Asset one must be specified");
        Validate.notNull((Object)two, (String)"Asset two must be specified");
        byte[] oneData = IOUtil.asByteArray((InputStream)one.openStream());
        byte[] twoData = IOUtil.asByteArray((InputStream)two.openStream());
        return Arrays.equals(oneData, twoData);
    }

    protected int numAssets(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        int assets = 0;
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            if (((Node)entry.getValue()).getAsset() == null) continue;
            ++assets;
        }
        return assets;
    }
}

