/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.Assert;
import org.junit.Test;

public class ServiceProviderAssetTestCase {
    @Test
    public void shouldCreateServiceProviderFile() throws Exception {
        ServiceProviderAsset asset = new ServiceProviderAsset(new Class[]{TestImpl1.class, TestImpl2.class});
        byte[] expectedContent = (TestImpl1.class.getName() + "\n" + TestImpl2.class.getName() + "\n").getBytes();
        byte[] content = IOUtil.asByteArray((InputStream)asset.openStream());
        Assert.assertArrayEquals((byte[])expectedContent, (byte[])content);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnNullArgumnet() throws Exception {
        new ServiceProviderAsset((Class[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnNullArgumnetValue() throws Exception {
        new ServiceProviderAsset(new Class[]{null});
    }

    private class TestImpl2
    implements TestIF {
        private TestImpl2() {
        }
    }

    private class TestImpl1
    implements TestIF {
        private TestImpl1() {
        }
    }

    private static interface TestIF {
    }
}

