/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamImporterImplTestBase<T extends StreamImporter<T>> {
    private static final Logger log = Logger.getLogger(StreamImporterImplTestBase.class.getName());
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";

    protected abstract ContentAssertionDelegateBase getDelegate();

    protected abstract Class<T> getImporterClass();

    protected abstract Class<? extends StreamExporter> getExporterClass();

    protected abstract InputStream getExceptionThrowingInputStream();

    @Test
    public void shouldBeAbleToImportFile() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testFile).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        delegate.assertContent(archive, testFile);
    }

    @Test
    public void shouldNotBeAbleToImportDirectory() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testDir = delegate.getExistingResource().getParentFile();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        try {
            ((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testDir);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        Assert.fail((String)("Should have received " + IllegalArgumentException.class.getSimpleName() + " on attempt to import a dir"));
    }

    @Test
    public void shouldBeAbleToImportAddAndExport() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testFile).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        archive.add((Asset)new ClassLoaderAsset(EXISTING_RESOURCE), ArchivePaths.create((String)"test.properties"));
        File tempFile = new File("target/testOutput");
        tempFile.deleteOnExit();
        Class<StreamExporter> exporterClass = this.getExporterClass();
        Assert.assertNotNull((String)"Exporter class must be specified by implementations", exporterClass);
        InputStream stream = ((StreamExporter)archive.as(exporterClass)).exportAsInputStream();
        IOUtil.copyWithClose((InputStream)stream, (OutputStream)new FileOutputStream(tempFile));
        delegate.assertContent(archive, tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToImportInputStream() throws Exception {
        Archive archive;
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        FileInputStream stream = new FileInputStream(testFile);
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        StreamImporter importer = (StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar");
        try {
            archive = (Archive)importer.importFrom((InputStream)stream).as(GenericArchive.class);
        }
        finally {
            ((InputStream)stream).close();
        }
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        delegate.assertContent(archive, testFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromStream() throws Exception {
        InputStream exceptionIn = this.getExceptionThrowingInputStream();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        StreamImporter importer = (StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar");
        try {
            GenericArchive archive = (GenericArchive)importer.importFrom(exceptionIn).as(GenericArchive.class);
            log.info("Imported: " + archive.toString(true));
        }
        finally {
            exceptionIn.close();
        }
    }
}

