/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.TarGzExporter;
import org.jboss.shrinkwrap.api.importer.TarGzImporter;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.importer.StreamImporterImplTestBase;
import org.jboss.shrinkwrap.impl.base.importer.TarGzContentAssertionDelegate;
import org.jboss.shrinkwrap.impl.base.io.tar.TarGzInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarGzImporterImplTestCase
extends StreamImporterImplTestBase<TarGzImporter> {
    private static final Logger log = Logger.getLogger(TarGzImporterImplTestCase.class.getName());
    private static final TarGzContentAssertionDelegate delegate = new TarGzContentAssertionDelegate();

    @Override
    protected ContentAssertionDelegateBase getDelegate() {
        return delegate;
    }

    @Override
    protected Class<TarGzImporter> getImporterClass() {
        return TarGzImporter.class;
    }

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return TarGzExporter.class;
    }

    protected TarGzInputStream getExceptionThrowingInputStream() {
        try {
            return ExceptionThrowingTarGzInputStream.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not occur in test setup", e);
        }
    }

    private static final class ExceptionThrowingTarGzInputStream
    extends TarGzInputStream {
        static ExceptionThrowingTarGzInputStream create() throws IOException {
            byte[] test = "Something".getBytes();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            new GZIPOutputStream(stream).write(test);
            ByteArrayInputStream in = new ByteArrayInputStream(stream.toByteArray());
            return new ExceptionThrowingTarGzInputStream(in);
        }

        private ExceptionThrowingTarGzInputStream(InputStream in) throws IOException {
            super(in);
        }

        public int read() throws IOException {
            throw new RuntimeException("Mock Exception, should be wrapped in the import process");
        }
    }
}

