/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.junit.Test;

public class ArchiveEqualsHashCodeTestCase {
    private static final String TEST_ZIP_1 = "org/jboss/shrinkwrap/impl/base/importer/test.zip";
    private static final String TEST_ZIP_2 = "org/jboss/shrinkwrap/impl/base/asset/test.zip";

    @Test
    public void archiveEqualsShouldReturnTrueWhenNameAndContentsAreEqual() throws Exception {
        File testFile = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        File testFile2 = TestIOUtil.createFileFromResourceName(TEST_ZIP_2);
        Archive archive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        Archive archive2 = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile2);
        Assert.assertEquals((String)"Archives were not equal, but should be.", (Object)archive, (Object)archive2);
    }

    @Test
    public void archiveEqualsShouldReturnTrueWhenEqualByReference() throws Exception {
        File testFile = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        File testFile2 = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        Archive archive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        Archive archive2 = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile2);
        Assert.assertEquals((String)"Archives were not equal, but should be.", (Object)archive, (Object)archive2);
    }

    @Test
    public void archiveEqualsShouldReturnFalseWhenArchivesContentsAreNotEqual() throws Exception {
        String archiveName = "test.zip";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.zip");
        File testFile = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        JavaArchive archive2 = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        Assert.assertFalse((String)"Archives were equal, but should not have been - contents differ.", (boolean)archive.equals(archive2));
    }

    @Test
    public void archiveEqualsShouldReturnFalseWhenArchivesNamesAreNotEqual() throws Exception {
        String archiveName = "test.war";
        String archiveName2 = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.war");
        JavaArchive archive2 = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        Assert.assertFalse((String)"Archives were equal, but should not have been - names differ.", (boolean)archive.equals(archive2));
    }

    @Test
    public void enterpriseArchiveEqualsShouldReturnTrueWhenNameAndContentsAreEqual() throws Exception {
        File testFile1 = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        File testFile2 = TestIOUtil.createFileFromResourceName(TEST_ZIP_2);
        EnterpriseArchive ear1 = (EnterpriseArchive)ShrinkWrap.createFromZipFile(EnterpriseArchive.class, (File)testFile1);
        EnterpriseArchive ear2 = (EnterpriseArchive)ShrinkWrap.createFromZipFile(EnterpriseArchive.class, (File)testFile2);
        Assert.assertEquals((String)"EnterpriseArchive instances were not equal, but should be.", (Object)ear1, (Object)ear2);
    }

    @Test
    public void javaArchiveShouldEqualEnterpriseArchiveWhenNameAndContentsAreEqual() throws Exception {
        File testFile1 = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        File testFile2 = TestIOUtil.createFileFromResourceName(TEST_ZIP_2);
        JavaArchive jar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile1);
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.createFromZipFile(EnterpriseArchive.class, (File)testFile2);
        Assert.assertEquals((String)"JavaArchive and EnterpriseArchive were not equal, but should be.", (Object)jar, (Object)ear);
    }

    @Test
    public void archiveHashCodeShouldBeIdempotent() throws Exception {
        File testFile1 = TestIOUtil.createFileFromResourceName(TEST_ZIP_1);
        JavaArchive jar = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile1);
        Assert.assertEquals((String)"hashCode did not return consistent value for same instance", (int)jar.hashCode(), (int)jar.hashCode());
    }
}

