/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipExporterTestCase
extends StreamExporterTestBase<ZipImporter> {
    private static final String EXTENSION = ".jar";

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return ZipExporter.class;
    }

    @Override
    protected Class<ZipImporter> getImporterClass() {
        return ZipImporter.class;
    }

    @Override
    protected void ensureInExpectedForm(File file) throws IOException {
        assert (file != null) : "file must be specified";
        ZipFile zip = new ZipFile(file);
        this.ensureZipFileInExpectedForm(zip);
    }

    @Override
    protected InputStream getContentsFromExportedFile(File file, ArchivePath path) throws IOException {
        assert (file != null) : "file must be specified";
        assert (path != null) : "path must be specified";
        ZipFile zipFile = new ZipFile(file);
        ZipEntry entry = zipFile.getEntry(PathUtil.optionallyRemovePrecedingSlash((String)path.get()));
        if (entry == null) {
            return null;
        }
        byte[] actualContents = IOUtil.asByteArray((InputStream)zipFile.getInputStream(entry));
        return new ByteArrayInputStream(actualContents);
    }

    @Override
    protected String getArchiveExtension() {
        return EXTENSION;
    }

    @Test(expected=IllegalArgumentException.class)
    public void exportEmptyArchiveAsZip() throws Exception {
        ((ZipExporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"testArchive")).as(ZipExporter.class)).exportAsInputStream();
    }

    @Test
    public void exportShouldFailIfTargetExist() throws IOException {
        File target = new File(this.createTempDirectory("exportShouldFailIfTargetExist.jar").getAbsolutePath());
        if (target.exists()) {
            Assert.assertTrue((boolean)target.delete());
        }
        Assert.assertFalse((boolean)target.exists());
        ((ZipExporter)this.createArchiveWithAssets().as(ZipExporter.class)).exportTo(target);
        Assert.assertTrue((boolean)target.exists());
        try {
            ((ZipExporter)this.createArchiveWithAssets().as(ZipExporter.class)).exportTo(target);
            Assert.fail((String)"Expected a FileExistsException when exporting to an existing path");
        }
        catch (Exception e) {
            Assert.assertEquals(FileExistsException.class, e.getClass());
        }
    }

    private void ensureZipFileInExpectedForm(ZipFile expectedZip) throws IOException {
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        this.getEntryFromZip(expectedZip, NESTED_PATH);
        ZipEntry rootEntry = expectedZip.getEntry("/");
        Assert.assertNull((String)"ZIP should not have explicit root path written (SHRINKWRAP-96)", (Object)rootEntry);
    }

    private void assertAssetInZip(ZipFile expectedZip, ArchivePath path, Asset asset) throws IllegalArgumentException, IOException {
        ZipEntry entry = this.getEntryFromZip(expectedZip, path);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)expectedZip.getInputStream(entry));
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private ZipEntry getEntryFromZip(ZipFile expectedZip, ArchivePath path) throws IllegalArgumentException, IOException {
        String entryPath = PathUtil.optionallyRemovePrecedingSlash((String)path.get());
        ZipEntry entry = expectedZip.getEntry(entryPath);
        Assert.assertNotNull((String)("Expected path not found in ZIP: " + path), (Object)entry);
        return entry;
    }
}

