/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.importer.StreamImporterImplTestBase;
import org.jboss.shrinkwrap.impl.base.importer.ZipContentAssertionDelegate;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipImporterImplTestCase
extends StreamImporterImplTestBase<ZipImporter> {
    private static final Logger log = Logger.getLogger(ZipImporterImplTestCase.class.getName());
    private static final ZipContentAssertionDelegate delegate = new ZipContentAssertionDelegate();

    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromFile() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        ZipFile testZip = new ZipFile(testFile){

            @Override
            public Enumeration<? extends ZipEntry> entries() {
                throw new IllegalStateException("mock  exception");
            }
        };
        ((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)"test.jar")).importFrom(testZip).as(JavaArchive.class);
    }

    @Override
    protected ContentAssertionDelegateBase getDelegate() {
        return delegate;
    }

    @Override
    protected Class<ZipImporter> getImporterClass() {
        return ZipImporter.class;
    }

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return ZipExporter.class;
    }

    @Override
    protected InputStream getExceptionThrowingInputStream() {
        return new InputStream(){

            public int read() throws IOException {
                throw new IOException("Mock exception");
            }
        };
    }

    @Test
    public void createZipImporter() {
        GenericArchive importer = (GenericArchive)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).as(GenericArchive.class);
        Assert.assertTrue((String)"Archive did not have expected suffix", (boolean)importer.getName().endsWith(".jar"));
    }
}

