/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.handler.ReplaceAssetHandler;
import org.jboss.shrinkwrap.impl.base.test.handler.SimpleHandler;
import org.jboss.shrinkwrap.spi.ArchiveFormatAssociable;
import org.junit.After;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveTestBase<T extends Archive<T>> {
    public static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    public static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";

    protected abstract T getArchive();

    protected abstract Archive<T> createNewArchive();

    protected abstract ArchiveFormat getExpectedArchiveFormat();

    @Test
    public void testDefaultArchiveFormatIsSet() throws Exception {
        Assert.assertEquals((String)"Unexpected default archive format", (Object)this.getExpectedArchiveFormat(), (Object)this.getDefaultArchiveFormat());
    }

    private ArchiveFormat getDefaultArchiveFormat() {
        return ((ArchiveFormatAssociable)this.getArchive()).getArchiveFormat();
    }

    @After
    public void ls() {
        T archive = this.getArchive();
        System.out.println("test@jboss:/$ ls -l " + archive.getName());
        System.out.println(archive.toString(true));
    }

    @Test
    public void testAddAssetToPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        Assert.assertTrue((String)("Asset should be placed on " + location.get()), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, (ArchivePath)new BasicPath("/", "Test.properties"));
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, location.get());
        Assert.assertTrue((String)("Asset should be placed on " + new BasicPath("/", "test.properties")), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddWithStringPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPathRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, "/Test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithArchivePathAndName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ArchivePath location = ArchivePaths.root();
        archive.add((Asset)asset, location, "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testAddAssetWithStringPathAndName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "/", "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testAddAssetWithNameRequiresArchivePath() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (ArchivePath)null, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAssetWithNameRequiresStringPath() throws Exception {
        T archive = this.getArchive();
        archive.add((Asset)EmptyAsset.INSTANCE, (String)null, "childPath");
    }

    @Test
    public void testAddAssetWithNameRequiresName() throws Exception {
        T archive = this.getArchive();
        BasicPath path = new BasicPath("/", "Test.properties");
        String resource = NAME_TEST_PROPERTIES;
        try {
            archive.add((Asset)new ClassLoaderAsset(NAME_TEST_PROPERTIES), (ArchivePath)path, null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresAsset() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        BasicPath path = new BasicPath("/", "Test.properties");
        try {
            archive.add(null, (ArchivePath)path, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNamedAsset() throws Exception {
        T archive = this.getArchive();
        String testName = "check.properties";
        ClassLoaderAsset testAsset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        NamedAsset namedAsset = new NamedAsset((Asset)testAsset){
            final /* synthetic */ Asset val$testAsset;
            {
                this.val$testAsset = asset;
            }

            public String getName() {
                return "check.properties";
            }

            public InputStream openStream() {
                return this.val$testAsset.openStream();
            }
        };
        archive.add(namedAsset);
        Assert.assertTrue((String)"Asset should be placed on check.properties", (boolean)archive.contains("check.properties"));
    }

    @Test
    public void testAddEmptyDirectories() throws Exception {
        T archive = this.getArchive();
        ArchivePath path1 = ArchivePaths.create((String)"path/to/dir");
        ArchivePath path2 = ArchivePaths.create((String)"path/to/dir2");
        ArchivePath path3 = ArchivePaths.create((String)"path/to");
        archive.addAsDirectories(new ArchivePath[]{path1, path2, path3});
        String message = "Should be able to add directory: ";
        TestCase.assertTrue((String)("Should be able to add directory: " + path1), (boolean)archive.contains(path1));
        TestCase.assertTrue((String)("Should be able to add directory: " + path2), (boolean)archive.contains(path2));
        TestCase.assertTrue((String)("Should be able to add directory: " + path3), (boolean)archive.contains(path3));
    }

    @Test
    public void testHandlerIsCalledWhenAddingDirectoriesWithArchivePath() throws Exception {
        SimpleHandler simpleHandler1 = new SimpleHandler();
        SimpleHandler simpleHandler2 = new SimpleHandler();
        this.getArchive().addHandlers(new ArchiveEventHandler[]{simpleHandler1, simpleHandler2});
        this.getArchive().addAsDirectories(new ArchivePath[]{ArchivePaths.create((String)"/path/to/dir1")});
        Assert.assertTrue((String)"Handler not called", (boolean)simpleHandler1.called);
        Assert.assertTrue((String)"Handler not called", (boolean)simpleHandler2.called);
    }

    @Test
    public void testHandlerIsCalledWhenAddingDirectoriesWithStringPath() throws Exception {
        SimpleHandler simpleHandler1 = new SimpleHandler();
        SimpleHandler simpleHandler2 = new SimpleHandler();
        this.getArchive().addHandlers(new ArchiveEventHandler[]{simpleHandler1, simpleHandler2});
        this.getArchive().addAsDirectories(new String[]{"/path/to/dir1"});
        Assert.assertTrue((String)"Handler not called", (boolean)simpleHandler1.called);
        Assert.assertTrue((String)"Handler not called", (boolean)simpleHandler2.called);
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePath() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir/test1.txt");
        StringAsset asset = new StringAsset("Asset content");
        this.getArchive().add((Asset)asset, path);
        Assert.assertEquals((String)"Handler not called", (String)"EXPECTED", (String)this.readStringAsset(path));
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)asset, (Object)handler1.savedAsset);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)handler1.returnedAsset, (Object)handler2.savedAsset);
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePathAndName() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path, "asset.txt");
        String actual = this.readStringAsset(ArchivePaths.create((ArchivePath)path, (String)"/asset.txt"));
        Assert.assertEquals((String)"Handler not called", (String)"EXPECTED", (String)actual);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)asset, (Object)handler1.savedAsset);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)handler1.returnedAsset, (Object)handler2.savedAsset);
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithtStringPathAndName() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path.get(), "asset.txt");
        String actual = this.readStringAsset(ArchivePaths.create((ArchivePath)path, (String)"asset.txt"));
        Assert.assertEquals((String)"Handler not called", (String)"EXPECTED", (String)actual);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)asset, (Object)handler1.savedAsset);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)handler1.returnedAsset, (Object)handler2.savedAsset);
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithStringPath() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir/test1.txt");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path.get());
        Assert.assertEquals((String)"Handler not called", (String)"EXPECTED", (String)this.readStringAsset(path));
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)asset, (Object)handler1.savedAsset);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)handler1.returnedAsset, (Object)handler2.savedAsset);
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePathAndExporter() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        Archive asset = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"asset.zip")).add((Asset)new StringAsset("asset content"), "content.txt");
        this.getArchive().add(asset, path, ZipExporter.class);
        Assert.assertTrue((String)"Handler not called", (boolean)handler1.called);
        Assert.assertEquals((String)"Wrong asset received by handler", (Object)handler1.returnedAsset, (Object)handler2.savedAsset);
    }

    @Test
    public void testContainsPathAsString() {
        T archive = this.getArchive();
        String path = "testpath";
        archive.add((Asset)EmptyAsset.INSTANCE, "testpath");
        Assert.assertTrue((String)"Archive should contain the path added", (boolean)archive.contains("testpath"));
    }

    @Test
    public void testContainsPathAsArchivePath() {
        T archive = this.getArchive();
        ArchivePath path = ArchivePaths.create((String)"testpath");
        archive.add((Asset)EmptyAsset.INSTANCE, path);
        Assert.assertTrue((String)"Archive should contain the path added", (boolean)archive.contains(path));
    }

    @Test
    public void testDeleteAssetWithArchivePath() throws Exception {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(resource);
        archive.add((Asset)asset, (ArchivePath)location);
        Assert.assertTrue((boolean)archive.contains((ArchivePath)location));
        Assert.assertEquals((String)"Successfully deleting an Asset should return the removed Node", (Object)asset, (Object)archive.delete((ArchivePath)location).getAsset());
        Assert.assertFalse((String)("There should no longer be an asset at: " + location.get() + " after deleted"), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testDeleteAssetWithStringPath() throws Exception {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        String location = "/test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(resource);
        archive.add((Asset)asset, location);
        Assert.assertTrue((boolean)archive.contains(location));
        Assert.assertEquals((String)"Successfully deleting an Asset should return the removed Node", (Object)asset, (Object)archive.delete(location).getAsset());
        Assert.assertFalse((String)("There should no longer be an asset at: " + location + " after deleted"), (boolean)archive.contains(location));
    }

    @Test
    public void testDeleteMissingAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        Assert.assertNull((String)"Deleting a non-existent Asset should return null", (Object)archive.delete((ArchivePath)location));
    }

    @Test
    public void testDeleteMissingAssetWithStringPath() throws Exception {
        T archive = this.getArchive();
        String location = "/test.properties";
        Assert.assertNull((String)"Deleting a non-existent Asset should return null", (Object)archive.delete(location));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeleteAssetRequiresArchivePath() throws Exception {
        T archive = this.getArchive();
        archive.delete((ArchivePath)null);
        Assert.fail((String)"Should have throw an IllegalArgumentException");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeleteAssetRequiresStringPath() throws Exception {
        T archive = this.getArchive();
        archive.delete((String)null);
        Assert.fail((String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testGetAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get((ArchivePath)location);
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAssetWithString() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get(location.get());
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetWithStringRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testImportArchiveAsTypeFromString() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, resourcePath, ArchiveFormat.ZIP)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain a new asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test
    public void testImportArchiveAsTypeFromStringUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, resourcePath)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain a new asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test
    public void testImportArchiveAsTypeFromArchivePath() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, ArchivePaths.create((String)resourcePath), ArchiveFormat.ZIP)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain an archive asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test
    public void testImportArchiveAsTypeFromArchivePathUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, ArchivePaths.create((String)resourcePath))).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain an archive asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test
    public void testImportArchiveAsTypeFromFilter() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        Collection jars = archive.getAsType(JavaArchive.class, Filters.include((String)".*jar"), ArchiveFormat.ZIP);
        Assert.assertEquals((String)"Unexpected result found", (int)1, (int)jars.size());
        JavaArchive jar = (JavaArchive)((JavaArchive)jars.iterator().next()).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain a new asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test
    public void testImportArchiveAsTypeFromFilterUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        Collection jars = archive.getAsType(JavaArchive.class, Filters.include((String)".*jar"));
        Assert.assertEquals((String)"Unexpected result found", (int)1, (int)jars.size());
        JavaArchive jar = (JavaArchive)((JavaArchive)jars.iterator().next()).add((Asset)new StringAsset("test file content"), "test.txt");
        Assert.assertEquals((String)"JAR imported with wrong name", (String)resourcePath, (String)jar.getName());
        Assert.assertNotNull((String)"Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass.class"));
        Assert.assertNotNull((String)"Inner Class in JAR not imported", (Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"));
        Assert.assertNotNull((String)"Should contain a new asset", (Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromStringThrowExceptionIfClassIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, "/path", ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromStringThrowExceptionIfPathIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (String)null, ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromStringThrowExceptionIfFormatIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, "/path", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromArchivePathThrowExceptionIfClassIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, ArchivePaths.create((String)"/path"), ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromArchivePathThrowExceptionIfPathIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (ArchivePath)null, ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromArchivePathThrowExceptionIfFormatIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, ArchivePaths.create((String)"/path"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromFilterThrowExceptionIfClassIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, Filters.includeAll(), ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromFilterThrowExceptionIfPathIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (Filter)null, ArchiveFormat.ZIP);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testImportArchiveFromFilterThrowExceptionIfFormatIsNull() throws Exception {
        ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, Filters.includeAll(), null);
    }

    @Test
    public void testGetAsTypeString() throws Exception {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, child.getName());
        Assert.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeArchivePath() throws Exception {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, ArchivePaths.create((String)child.getName()));
        Assert.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeWithFilter() throws Exception {
        GenericArchive child1 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child2 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child3 = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"SHOULD_NOT_BE_FOUND.xxx");
        Archive archive = this.getArchive().add((Archive)child1, "/", ZipExporter.class).add((Archive)child2, "/", ZipExporter.class).add((Archive)child3, "/", ZipExporter.class);
        Collection matches = archive.getAsType(GenericArchive.class, Filters.include((String)".*\\.jar"));
        Assert.assertNotNull((Object)matches);
        Assert.assertEquals((String)"Two archives should be found", (int)2, (int)matches.size());
        for (GenericArchive match : matches) {
            if (match.getName().equals(child1.getName()) || match.getName().equals(child2.getName())) continue;
            Assert.fail((String)("Wrong archive found, " + match.getName() + ". Expected " + child1.getName() + " or " + child2.getName()));
        }
    }

    @Test
    public void testToGetContent() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent();
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertTrue((String)("Asset should existing in content with key: " + location.get()), (boolean)this.compareAssets((Asset)asset, node1.getAsset()));
        Assert.assertTrue((String)("Asset should existing in content with key: " + locationTwo.get()), (boolean)this.compareAssets((Asset)assetTwo, node2.getAsset()));
    }

    @Test
    public void testToGetContentFiltered() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent(Filters.include((String)".*test2.*"));
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertEquals((String)"Only 1 Asset should have been included", (int)1, (int)content.size());
        Assert.assertNull((String)"Should not be included in content", (Object)node1);
        Assert.assertNotNull((String)"Should be included in content", (Object)node2);
    }

    @Test
    public void testAddArchiveToPathRequireArchivePath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (ArchivePath)null, ZipExporter.class);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddArchiveToPathRequireStringPath() throws Exception {
        T archive = this.getArchive();
        archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (String)null, ZipExporter.class);
    }

    @Test
    public void testAddArchiveToPathRequireArchive() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)null, ArchivePaths.root(), ZipExporter.class);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddAssetOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        ArchivePath locationTwo = ArchivePaths.create((String)"/test.properties/somewhere");
        archive.add((Asset)assetTwo, locationTwo);
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddDirectoryOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/somewhere/test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        archive.addAsDirectory("/somewhere/test.properties/test");
    }

    @Test
    public void testMergeRequiresSource() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMerge() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive);
        Node node1 = archive.get((ArchivePath)location);
        Node node2 = archive.get((ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node1.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node2.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToStringPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation);
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPathWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeToStringPathWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        Assert.assertTrue((String)("Asset should have been added to path: " + locationTwo.get()), (boolean)this.compareAssets(archive.get((ArchivePath)locationTwo).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeToPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(this.createNewArchive(), (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMergeWithDirectories() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/dir/", "test.properties");
        BasicPath locationTwo = new BasicPath("/dir/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.add((Asset)asset, (ArchivePath)location);
        archive.merge(sourceArchive);
        Assert.assertTrue((String)"Archive should contain given element", (boolean)archive.contains("/dir/test.properties"));
        Assert.assertTrue((String)"Archive should contain given element", (boolean)archive.contains("/dir/test2.properties"));
        Assert.assertEquals((String)"Archive children count is invalid", (int)2, (int)this.countChildren((Archive<?>)archive));
    }

    private int countChildren(Archive<?> archive) {
        Node node = archive.get("/");
        return this.countChildren(node);
    }

    private int countChildren(Node node) {
        int count = 0;
        for (Node child : node.getChildren()) {
            if (child.getAsset() != null) {
                ++count;
            }
            count += this.countChildren(child);
        }
        return count;
    }

    @Test
    public void testAddArchiveToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        Node node = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Asset should have been added to path: " + expectedPath.get()), (Object)node);
        Assert.assertTrue((String)("An instance of ArchiveAsset should have been added to path: " + expectedPath.get()), (boolean)(node.getAsset() instanceof ArchiveAsset));
        ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(node.getAsset());
        Archive nestedArchive = archiveAsset.getArchive();
        Assert.assertEquals((String)"Nested Archive should be same archive that was added", sourceArchive, (Object)nestedArchive);
    }

    @Test
    public void testNestedArchiveContains() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        sourceArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath archivePath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)archivePath, "test.properties");
        Assert.assertTrue((String)"Nested archive assets should be verified through a fully qualified path", (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testNestedArchiveGet() throws Exception {
        T archive = this.getArchive();
        Archive<T> nestedArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(nestedArchive, (ArchivePath)baseLocation, ZipExporter.class);
        Archive<T> nestedNestedArchive = this.createNewArchive();
        nestedArchive.add(nestedNestedArchive, ArchivePaths.root(), ZipExporter.class);
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        nestedNestedArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath nestedArchivePath = new BasicPath((ArchivePath)baseLocation, nestedArchive.getName());
        BasicPath nestedNestedArchivePath = new BasicPath((ArchivePath)nestedArchivePath, nestedNestedArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)nestedNestedArchivePath, "test.properties");
        Node nestedNode = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Nested archive asset should be available through partent archive at " + expectedPath.get()), (Object)nestedNode.getAsset());
    }

    @Test
    public void shouldMoveAsset() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "path1";
        String targetPath = "path2";
        archive.add((Asset)EmptyAsset.INSTANCE, "path1");
        archive.move("path1", "path2");
        Assert.assertEquals((String)"The archive should have only one asset", (int)1, (int)this.numAssets(archive));
        Assert.assertNotNull((String)"The asset should be at the target path", (Object)archive.get("path2"));
    }

    @Test
    public void shouldMoveDirectory() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "path1";
        String targetPath = "path2";
        archive.addAsDirectory("path1");
        archive.move("path1", "path2");
        Assert.assertTrue((String)"Directory should be at the new path", (archive.get("path2").getAsset() == null ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotMoveAssetBecauseOfInexistentPath() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "non-existent-path1";
        String targetPath = "path2";
        archive.move("non-existent-path1", "path2");
    }

    @Test
    public void ensureShallowCopyPreservesPointers() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location");
        Archive copyArchive = archive.shallowCopy();
        Assert.assertTrue((boolean)copyArchive.contains("location"));
        Assert.assertSame((Object)copyArchive.get("location").getAsset(), (Object)archive.get("location").getAsset());
    }

    @Test
    public void ensureShallowCopyHasASeparateCollectionOfTheSamePointers() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location");
        Archive copyArchive = archive.shallowCopy();
        archive.delete("location");
        Assert.assertTrue((boolean)copyArchive.contains("location"));
    }

    @Test
    public void ensureShallowCopyOperatesOnNestedAssets() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location/sublocation");
        Archive copyArchive = archive.shallowCopy();
        Assert.assertTrue((boolean)copyArchive.contains("location"));
        Assert.assertTrue((boolean)copyArchive.contains("location/sublocation"));
        Assert.assertSame((Object)copyArchive.get("location/sublocation").getAsset(), (Object)archive.get("location/sublocation").getAsset());
    }

    @Test
    public void testId() {
        JavaArchive one = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        JavaArchive two = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        System.out.println("ALR: " + one.getId());
    }

    private boolean compareAssets(Asset one, Asset two) throws IllegalArgumentException {
        Validate.notNull((Object)one, (String)"Asset one must be specified");
        Validate.notNull((Object)two, (String)"Asset two must be specified");
        byte[] oneData = IOUtil.asByteArray((InputStream)one.openStream());
        byte[] twoData = IOUtil.asByteArray((InputStream)two.openStream());
        return Arrays.equals(oneData, twoData);
    }

    protected int numAssets(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        int assets = 0;
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            if (((Node)entry.getValue()).getAsset() == null) continue;
            ++assets;
        }
        return assets;
    }

    private String readStringAsset(ArchivePath path) throws IOException {
        Asset addedAsset = this.getArchive().get(path).getAsset();
        return new BufferedReader(new InputStreamReader(addedAsset.openStream())).readLine();
    }
}

