/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFactory;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.GenericArchiveImpl;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.importer.ZipContentAssertionDelegate;
import org.junit.Test;

public class ShrinkWrapTestCase {
    private static final ZipContentAssertionDelegate delegate = new ZipContentAssertionDelegate();
    private static final String NAME_FILE_NON_ZIP = "nonzipfile.txt";

    @Test
    public void createNewArchiveUnderDefaultDomain() {
        String archiveName = "test.war";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.war");
        Assert.assertNotNull((String)"A archive should have been created", (Object)archive);
        Assert.assertEquals((String)"Should have the same name as given imput", (String)"test.war", (String)archive.getName());
    }

    @Test
    public void createIsolatedDomains() {
        Domain domain1 = ShrinkWrap.createDomain();
        Domain domain2 = ShrinkWrap.createDomain();
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain1);
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain2);
        TestCase.assertNotSame((String)"Creation of domains should return new instances", (Object)domain1, (Object)domain2);
        TestCase.assertNotSame((String)"Creation of domains should have unique / isolated configurations", (Object)domain1.getConfiguration(), (Object)domain2.getConfiguration());
    }

    @Test
    public void createDomainWithExplicitConfiguration() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((Configuration)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader).build());
        TestCase.assertEquals((String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)service, (Object)domain.getConfiguration().getExecutorService());
        TestCase.assertEquals((String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)loader, (Object)domain.getConfiguration().getExtensionLoader());
    }

    @Test
    public void createDomainWithExplicitConfigurationBuilder() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((ConfigurationBuilder)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader));
        TestCase.assertEquals((String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)service, (Object)domain.getConfiguration().getExecutorService());
        TestCase.assertEquals((String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)loader, (Object)domain.getConfiguration().getExtensionLoader());
    }

    @Test
    public void serviceExtensionLoadingUsesExplicitDomainClassLoader() {
        Class<CustomArchive> assignable = CustomArchive.class;
        try {
            ShrinkWrap.create(assignable);
        }
        catch (UnknownExtensionTypeException uete) {
            // empty catch block
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(TestSecurityActions.getThreadContextClassLoader());
        classLoaders.add(new URLClassLoader(new URL[0]){

            public InputStream getResourceAsStream(String name) {
                String thisClassName = this.getClass().getName().substring(0, this.getClass().getName().length() - 1);
                String searchName = "META-INF/services/" + thisClassName + CustomArchive.class.getSimpleName();
                if (name.equals(searchName)) {
                    return new ByteArrayInputStream(("implementingClassName=" + thisClassName + CustomArchiveImpl.class.getSimpleName() + "\nextension=.jar").getBytes());
                }
                return super.getResourceAsStream(name);
            }
        });
        ConfigurationBuilder builder = new ConfigurationBuilder().classLoaders(classLoaders);
        ArchiveFactory factory = ShrinkWrap.createDomain((ConfigurationBuilder)builder).getArchiveFactory();
        Assignable archive = factory.create(assignable);
        Assert.assertNotNull((String)"Archive using custom extension available in explicit CL should have been loaded", (Object)archive);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDomainRequiresConfiguration() {
        ShrinkWrap.createDomain((Configuration)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDomainRequiresConfigurationBuilder() {
        ShrinkWrap.createDomain((ConfigurationBuilder)null);
    }

    @Test
    public void getDefaultDomain() {
        Domain domain1 = ShrinkWrap.getDefaultDomain();
        Domain domain2 = ShrinkWrap.getDefaultDomain();
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain1);
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain2);
        TestCase.assertSame((String)"Obtaining the default domain should always return the same instance (idempotent operation)", (Object)domain1, (Object)domain2);
    }

    @Test
    public void shouldBeAbleToAddOverride() throws Exception {
        Domain domain = ShrinkWrap.createDomain();
        domain.getConfiguration().getExtensionLoader().addOverride(JavaArchive.class, MockJavaArchiveImpl.class);
        JavaArchive archive = (JavaArchive)domain.getArchiveFactory().create(JavaArchive.class, "test.jar");
        Assert.assertEquals((String)"Should have overridden normal JavaArchive impl", MockJavaArchiveImpl.class, archive.getClass());
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForJavaArchive() throws Exception {
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        String archiveExtension = javaArchive.getName().substring(javaArchive.getName().lastIndexOf("."));
        Assert.assertEquals((String)"JavaArchive should have proper extension", (String)".jar", (String)archiveExtension);
    }

    @Test
    public void shouldCreateJavaArchiveWithGivenName() throws Exception {
        String archiveName = "testArchive";
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
        Assert.assertEquals((String)"JavaArchive should have given name", (String)archiveName, (String)javaArchive.getName());
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForWebArchive() throws Exception {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class);
        String archiveExtension = webArchive.getName().substring(webArchive.getName().lastIndexOf("."));
        Assert.assertEquals((String)"WebArchive should have proper extension", (String)".war", (String)archiveExtension);
    }

    @Test
    public void shouldCreateWebArchiveWithGivenName() throws Exception {
        String archiveName = "testArchive";
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archiveName);
        Assert.assertEquals((String)"WebArchive should have given name", (String)archiveName, (String)webArchive.getName());
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForEnterpriseArchive() throws Exception {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class);
        String archiveExtension = enterpriseArchive.getName().substring(enterpriseArchive.getName().lastIndexOf("."));
        Assert.assertEquals((String)"EnterpriseArchive should have proper extension", (String)".ear", (String)archiveExtension);
    }

    @Test
    public void shouldCreateEnterpriseArchiveWithGivenName() throws Exception {
        String archiveName = "testArchive";
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)archiveName);
        Assert.assertEquals((String)"EnterpriseArchive should have given name", (String)archiveName, (String)enterpriseArchive.getName());
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForResourceAdapterArchive() throws Exception {
        ResourceAdapterArchive resourceAdapterArchive = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class);
        String archiveExtension = resourceAdapterArchive.getName().substring(resourceAdapterArchive.getName().lastIndexOf("."));
        Assert.assertEquals((String)"ResourceAdapterArchive should have proper extension", (String)".rar", (String)archiveExtension);
    }

    @Test
    public void shouldCreateResourceAdapterArchiveWithGivenName() throws Exception {
        String archiveName = "testArchive";
        ResourceAdapterArchive resourceAdapterArchive = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)archiveName);
        Assert.assertEquals((String)"ResourceAdapterArchive should have given name", (String)archiveName, (String)resourceAdapterArchive.getName());
    }

    @Test
    public void shouldBeAbleToimportZipFileViaShrinkWrap() throws Exception {
        File testFile = delegate.getExistingResource();
        JavaArchive archive = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        Assert.assertEquals((String)"name of the archive imported from a ZIP file was not as expected", (String)testFile.getName(), (String)archive.getName());
        delegate.assertContent((Archive<?>)archive, testFile);
    }

    @Test
    public void shouldBeAbleToimportZipFileViaArchiveFactory() throws Exception {
        File testFile = delegate.getExistingResource();
        JavaArchive archive = (JavaArchive)ShrinkWrap.getDefaultDomain().getArchiveFactory().createFromZipFile(JavaArchive.class, testFile);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        Assert.assertEquals((String)"name of the archive imported from a ZIP file was not as expected", (String)testFile.getName(), (String)archive.getName());
        delegate.assertContent((Archive<?>)archive, testFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importFromNonZipFileThrowsException() throws Exception {
        File nonZipFile = new File(TestSecurityActions.getThreadContextClassLoader().getResource(NAME_FILE_NON_ZIP).toURI());
        ShrinkWrap.createFromZipFile(JavaArchive.class, (File)nonZipFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importFromNullFileThrowsException() throws Exception {
        ShrinkWrap.createFromZipFile(JavaArchive.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importFromNonexistantlFileThrowsException() throws Exception {
        File file = new File("fileThatDoesntExist.tmp");
        Assert.assertFalse((String)("Error in test setup, file should not exist: " + file.getAbsolutePath()), (boolean)file.exists());
        ShrinkWrap.createFromZipFile(JavaArchive.class, null);
    }

    @Test(expected=UnknownExtensionTypeException.class)
    public void shouldThrowExceptionOnNoConfiguredMappingForType() throws Exception {
        ShrinkWrap.create(MockAssignable.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockAssignable
    implements Assignable {
        private MockAssignable() {
        }

        public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockJavaArchiveImpl
    extends ContainerBase<JavaArchive>
    implements JavaArchive {
        public MockJavaArchiveImpl(Archive<?> archive) {
            super(JavaArchive.class, archive);
        }

        protected ArchivePath getClassesPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getLibraryPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getManifestPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getResourcePath() {
            return ArchivePaths.root();
        }

        public String toString(Formatter formatter) throws IllegalArgumentException {
            return formatter.format((Archive)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockExtensionLoader
    implements ExtensionLoader {
        private MockExtensionLoader() {
        }

        public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
            return null;
        }

        public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
            return null;
        }

        public <T extends Assignable> String getExtensionFromExtensionMapping(Class<T> extensionClass) {
            return null;
        }

        public <T extends Archive<T>> ArchiveFormat getArchiveFormatFromExtensionMapping(Class<T> extensionClass) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomArchiveImpl
    extends GenericArchiveImpl
    implements CustomArchive {
        public CustomArchiveImpl(Archive<?> delegate) {
            super(delegate);
        }
    }

    public static interface CustomArchive
    extends Assignable {
    }
}

