/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersTestCase {
    @Test
    public void shouldIncludeAll() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includeAll());
        Assert.assertArrayEquals((String)"Should include all paths", (Object[])paths.toArray(), (Object[])filteredPaths.toArray());
    }

    @Test
    public void shouldIncludePathRegExp() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.include((String)".*META-INF.*"));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain metainf", (Object)ArchivePaths.create((String)"/META-INF/"), (Object)filteredPaths.get(0));
    }

    @Test
    public void shouldExcludePathRegExp() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.exclude((String)".*META-INF.*"));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain webinf", (Object)ArchivePaths.create((String)"/WEB-INF/"), (Object)filteredPaths.get(0));
    }

    @Test
    public void shouldIncludePathsStringArray() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includePaths((String[])new String[]{"A", "B/"}));
        Assert.assertEquals((String)"Should contain two", (long)2L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should contain A", (Object)ArchivePaths.create((String)"/A"), (Object)filteredPaths.get(0));
        Assert.assertEquals((String)"Should contain B", (Object)ArchivePaths.create((String)"/B"), (Object)filteredPaths.get(1));
    }

    @Test
    public void shouldIncludePathsCollection() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includePaths(Arrays.asList("A", "B/")));
        Assert.assertEquals((String)"Should contain two", (long)2L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should contain A", (Object)ArchivePaths.create((String)"/A"), (Object)filteredPaths.get(0));
        Assert.assertEquals((String)"Should contain B", (Object)ArchivePaths.create((String)"/B"), (Object)filteredPaths.get(1));
    }

    @Test
    public void shouldExcludePathsStringArray() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.excludePaths((String[])new String[]{"/A", "/B/"}));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain C", (Object)ArchivePaths.create((String)"/C"), (Object)filteredPaths.get(0));
    }

    @Test
    public void shouldExcludePathsCollection() throws Exception {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.excludePaths(Arrays.asList("/A", "/B/")));
        Assert.assertEquals((String)"Should only contain one", (long)1L, (long)filteredPaths.size());
        Assert.assertEquals((String)"Should only contain C", (Object)ArchivePaths.create((String)"/C"), (Object)filteredPaths.get(0));
    }

    private <T> List<T> executeFilter(Class<T> clazz, List<T> items, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            if (!filter.include(item)) continue;
            result.add(item);
        }
        return result;
    }
}

