/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import junit.framework.Assert;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Test;

public class AssetUtilTestCase {
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";

    @Test
    public void shouldBeAbleToGetPathForClassloaderResource() throws Exception {
        ArchivePath foundResourcePath = AssetUtil.getPathForClassloaderResource((String)EXISTING_RESOURCE);
        Assert.assertEquals((String)"The classloader resource path should not contain the file name", (Object)new BasicPath("org/jboss/shrinkwrap/impl/base/asset"), (Object)foundResourcePath);
    }

    @Test
    public void shouldBeAbleToGetNameForClassloaderResource() throws Exception {
        String foundResourceName = AssetUtil.getNameForClassloaderResource((String)EXISTING_RESOURCE);
        Assert.assertEquals((String)"The classloader resource name should not contain the path", (String)"Test.properties", (String)foundResourceName);
    }

    @Test
    public void shouldBeAbleToGetFullPathForClassResoruce() throws Exception {
        ArchivePath foundClassResourcePath = AssetUtil.getFullPathForClassResource(this.getClass());
        Assert.assertEquals((String)"The class resource should have a / delimiter and a .class extension", (Object)new BasicPath("/org/jboss/shrinkwrap/impl/base/asset/AssetUtilTestCase.class"), (Object)foundClassResourcePath);
    }
}

