/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;

public class TestIOUtil {
    private TestIOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static void deleteDirectory(File directory) {
        if (directory.isDirectory() && directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    TestIOUtil.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new RuntimeException("Failed to delete file: " + file);
            }
            if (!directory.delete()) {
                throw new RuntimeException("Failed to delete directory: " + directory);
            }
        } else {
            throw new RuntimeException("Unable to delete directory: " + directory + ".  It is either not a directory or does not exist.");
        }
    }

    public static File createFileFromResourceName(String resourceName) throws URISyntaxException {
        assert (resourceName != null) : "Resource name must be specified";
        URL resourceLocation = TestSecurityActions.getThreadContextClassLoader().getResource(resourceName);
        assert (resourceLocation != null) : "Resource was not found at specified location: " + resourceName;
        return new File(resourceLocation.toURI());
    }

    public static InputStream createInputstreamFromResourceName(String resourceName) throws URISyntaxException {
        assert (resourceName != null) : "Resource name must be specified";
        InputStream resourceStream = TestSecurityActions.getThreadContextClassLoader().getResourceAsStream(resourceName);
        assert (resourceStream != null) : "Resource was not found at specified location: " + resourceName;
        return resourceStream;
    }
}

