/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassA;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AddPackageFromWarTest {
    private Domain domain;
    private Path temp;

    @Before
    public void setUp() throws IOException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"my.war");
        war.addClass(DummyClassA.class);
        this.temp = Files.createTempFile("test", ".war", new FileAttribute[0]);
        ((ZipExporter)war.as(ZipExporter.class)).exportTo(this.temp.toFile(), true);
        URL warUrl = this.temp.toUri().toURL();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        URLClassLoader warCl = new URLClassLoader(new URL[]{warUrl}, null);
        classLoaders.add(warCl);
        FilteringClassLoader shrinkwrapCl = new FilteringClassLoader(this.getClass().getClassLoader());
        classLoaders.add(shrinkwrapCl);
        builder.classLoaders(classLoaders);
        this.domain = ShrinkWrap.createDomain((Configuration)builder.build());
    }

    @After
    public void tearDown() throws IOException {
        Files.delete(this.temp);
    }

    @Test
    public void testAddPackage() {
        JavaArchive jar = (JavaArchive)this.domain.getArchiveFactory().create(JavaArchive.class);
        jar.addPackage("org.jboss.shrinkwrap.impl.base.spec.donotchange");
        Assert.assertNotNull((Object)jar.get("/" + DummyClassA.class.getName().replace('.', '/') + ".class"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringClassLoader
    extends ClassLoader {
        public FilteringClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.contains("donotchange")) {
                return null;
            }
            return super.loadClass(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.contains("donotchange")) {
                return Collections.emptyEnumeration();
            }
            return super.getResources(name);
        }
    }
}

