/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.nio.file;

import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileStore;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileSystemProvider;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapPath;

public class ShrinkWrapFileSystem
extends FileSystem {
    static final String FILE_ATTR_VIEW_BASIC = "basic";
    private final ShrinkWrapFileSystemProvider provider;
    private final Archive<?> archive;
    private final List<FileStore> fileStores;
    private volatile boolean open;

    public ShrinkWrapFileSystem(ShrinkWrapFileSystemProvider provider, Archive<?> archive) {
        this.provider = provider;
        this.archive = archive;
        this.open = true;
        ShrinkWrapFileStore store = new ShrinkWrapFileStore(this.archive);
        ArrayList<ShrinkWrapFileStore> stores = new ArrayList<ShrinkWrapFileStore>(1);
        stores.add(store);
        this.fileStores = Collections.unmodifiableList(stores);
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return ArchivePath.SEPARATOR_STRING;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        this.checkClosed();
        ShrinkWrapPath path = new ShrinkWrapPath(ArchivePaths.root(), this);
        ArrayList<ShrinkWrapPath> paths = new ArrayList<ShrinkWrapPath>(1);
        paths.add(path);
        return Collections.unmodifiableList(paths);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        this.checkClosed();
        return this.fileStores;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        this.checkClosed();
        HashSet<String> names = new HashSet<String>(1);
        names.add(FILE_ATTR_VIEW_BASIC);
        return Collections.unmodifiableSet(names);
    }

    @Override
    public Path getPath(String first, String ... more) {
        this.checkClosed();
        if (first == null) {
            throw new IllegalArgumentException("At least one path component must be specified");
        }
        String merged = this.merge(first, more);
        ShrinkWrapPath path = new ShrinkWrapPath(merged, this);
        return path;
    }

    private String merge(String first, String[] more) {
        assert (first != null) : "first must be specified";
        assert (more != null) : "more must be specified";
        StringBuilder merged = new StringBuilder();
        merged.append(first);
        for (int i = 0; i < more.length; ++i) {
            merged.append('/');
            merged.append(more[i]);
        }
        return merged.toString();
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.checkClosed();
        throw new UnsupportedOperationException("ShrinkWrap archives do not support Path Matcher operations");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("ShrinkWrap archives do not support file ownership.");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("ShrinkWrap archives do not support a " + WatchService.class.getSimpleName() + ".");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with mounted archive: " + this.archive.toString();
    }

    private void checkClosed() throws ClosedFileSystemException {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
    }

    Archive<?> getArchive() {
        return this.archive;
    }
}

