/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.SecurityActions;

public class ClassAsset
implements Asset {
    private static final char DELIMITER_RESOURCE_PATH = '/';
    private static final char DELIMITER_CLASS_NAME_PATH = '.';
    private static final String EXTENSION_CLASS = ".class";
    private Class<?> clazz;

    public ClassAsset(Class<?> clazz) {
        Validate.notNull(clazz, "Class must be specified");
        this.clazz = clazz;
    }

    public InputStream openStream() {
        ClassLoader classLoader = this.clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = SecurityActions.getThreadContextClassLoader();
        }
        return new ClassLoaderAsset(this.getResourceNameOfClass(this.clazz), classLoader).openStream();
    }

    private String getResourceNameOfClass(Class<?> clazz) throws IllegalArgumentException {
        String fqn = clazz.getName();
        String nameAsResourcePath = fqn.replace('.', '/');
        String resourceName = nameAsResourcePath + EXTENSION_CLASS;
        return resourceName;
    }
}

