/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.SpecializedBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class ZipImporterImpl
extends SpecializedBase
implements ZipImporter {
    private Archive<?> archive;

    public ZipImporterImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    public ZipImporter importZip(ZipInputStream stream) {
        Validate.notNull(stream, "Stream must be specified");
        try {
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                int readBytes;
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] content = new byte[1024];
                while ((readBytes = stream.read(content, 0, content.length)) != -1) {
                    output.write(content, 0, readBytes);
                }
                this.archive.add((Asset)new ByteArrayAsset(output.toByteArray()), entryName);
                stream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not import stream", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ingore) {}
        }
        return this;
    }

    public ZipImporter importZip(ZipFile file) {
        Validate.notNull(file, "File must be specified");
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            this.archive.add((Asset)new ZipFileEntryAsset(file, entry), (Path)new BasicPath(entryName));
        }
        return this;
    }
}

