/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class WebContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements WebContainer<T> {
    protected WebContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract Path getWebPath();

    public T setWebXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setWebXML(new ClassLoaderAsset(resourceName));
    }

    public T setWebXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML(new FileAsset(resource));
    }

    public T setWebXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML(new UrlAsset(resource));
    }

    public T setWebXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource(resource, "web.xml");
    }

    public T addWebResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), AssetUtil.getNameForClassloaderResource(resourceName));
    }

    public T addWebResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addWebResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addWebResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), target);
    }

    public T addWebResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addWebResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource(resource, (Path)new BasicPath(target));
    }

    public T addWebResource(String resourceName, Path target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addWebResource(File resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new FileAsset(resource), target);
    }

    public T addWebResource(URL resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addWebResource(Asset resource, Path target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getWebPath(), target);
        return this.add(resource, (Path)location);
    }
}

