/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.exporter.ZipExporterUtil;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.jboss.shrinkwrap.impl.base.io.StreamTask;

public class ZipExportDelegate
extends AbstractExporterDelegate<InputStream> {
    private static final Logger log = Logger.getLogger(ZipExportDelegate.class.getName());
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ZipOutputStream zipOutputStream;

    public ZipExportDelegate(Archive<?> archive) {
        super(archive);
    }

    @Override
    protected void export() {
        this.zipOutputStream = new ZipOutputStream(this.output);
        IOUtil.closeOnComplete(this.zipOutputStream, new StreamTask<ZipOutputStream>(){

            @Override
            public void execute(ZipOutputStream stream) throws Exception {
                ZipExportDelegate.super.export();
            }
        }, new StreamErrorHandler(){

            @Override
            public void handle(Throwable t) {
                throw new ArchiveExportException("Failed to export Zip: " + ZipExportDelegate.this.getArchive().getName(), t);
            }
        });
    }

    @Override
    protected void processAsset(Path path, Asset asset) {
        final String pathName = ZipExporterUtil.toZipEntryPath(path);
        final ZipEntry entry = new ZipEntry(pathName);
        InputStream assetStream = asset.openStream();
        IOUtil.closeOnComplete(assetStream, new StreamTask<InputStream>(){

            @Override
            public void execute(InputStream stream) throws Exception {
                ZipExportDelegate.this.zipOutputStream.putNextEntry(entry);
                IOUtil.copy(stream, ZipExportDelegate.this.zipOutputStream);
                ZipExportDelegate.this.zipOutputStream.closeEntry();
            }
        }, new StreamErrorHandler(){

            @Override
            public void handle(Throwable t) {
                throw new ArchiveExportException("Failed to write asset to Zip: " + pathName, t);
            }
        });
    }

    @Override
    protected InputStream getResult() {
        byte[] zipContent = this.output.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created Zip of size: " + zipContent.length + " bytes");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(zipContent);
        return inputStream;
    }
}

