/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

public class BasicPath
implements Path,
Comparable<Path> {
    private static final Logger log = Logger.getLogger(BasicPath.class.getName());
    private final String context;

    public BasicPath() {
        this(null);
    }

    public BasicPath(String context) {
        String resolvedContext = PathUtil.optionallyPrependSlash(context);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Resolved \"" + context + "\" to absolute form: " + resolvedContext);
        }
        this.context = resolvedContext;
    }

    public BasicPath(Path basePath, Path context) {
        this(basePath, context.get());
    }

    public BasicPath(Path basePath, String context) {
        this(basePath.get(), context);
    }

    public BasicPath(String basePath, String context) {
        this(PathUtil.composeAbsoluteContext(basePath, context));
    }

    public String get() {
        return this.context;
    }

    @Override
    public int compareTo(Path path) {
        if (path == null) {
            return 1;
        }
        return path.get().compareTo(this.get());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicPath other = (BasicPath)obj;
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [context=" + this.context + "]";
    }
}

