/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class ExplodedImporterImpl
extends AssignableBase
implements ExplodedImporter {
    private static final Logger log = Logger.getLogger(ExplodedImporterImpl.class.getName());
    private Archive<?> archive;

    public ExplodedImporterImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    public ExplodedImporter importDirectory(String fileName) {
        Validate.notNull(fileName, "FileName must be specified");
        return this.importDirectory(new File(fileName));
    }

    public ExplodedImporter importDirectory(File file) {
        Validate.notNull(file, "FileName must be specified");
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Given file is not a directory " + file.getAbsolutePath());
        }
        this.doImport(file, file.listFiles());
        return this;
    }

    private void doImport(File root, File[] files) {
        for (File file : files) {
            log.info(file.getAbsolutePath());
            Path path = this.calculatePath(root, file);
            if (file.isDirectory()) {
                this.archive.add((Asset)DirectoryAsset.INSTANCE, path);
                this.doImport(root, file.listFiles());
                continue;
            }
            this.archive.add((Asset)new FileAsset(file), path);
        }
    }

    private Path calculatePath(File root, File child) {
        String rootPath = this.unifyPath(root.getPath());
        String childPath = this.unifyPath(child.getPath());
        String archiveChildPath = childPath.replaceFirst(rootPath, "");
        return new BasicPath(archiveChildPath);
    }

    private String unifyPath(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

