/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.impl.base.SecurityActions;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

public class ServiceExtensionLoader
implements ExtensionLoader {
    private static final Logger log = Logger.getLogger(ServiceExtensionLoader.class.getName());
    private ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
    private Map<Class<?>, Class<?>> cache = new HashMap();

    public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
        if (this.isCached(extensionClass)) {
            return this.createFromCache(extensionClass, baseArchive);
        }
        T object = this.createFromLoadExtension(extensionClass, baseArchive);
        this.addToCache(extensionClass, object.getClass());
        return object;
    }

    boolean isCached(Class<?> extensionClass) {
        return this.cache.containsKey(extensionClass);
    }

    private <T extends Assignable> T createFromCache(Class<T> extensionClass, Archive<?> archive) {
        Class<T> extensionImplClass = this.getFromCache(extensionClass);
        return this.createExtension(extensionImplClass, archive);
    }

    void addToCache(Class<?> extensionClass, Class<?> extensionImplClass) {
        this.cache.put(extensionClass, extensionImplClass);
    }

    <T extends Assignable> Class<T> getFromCache(Class<T> extensionClass) {
        return this.cache.get(extensionClass);
    }

    public <T extends Assignable> ServiceExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
        this.addToCache(extensionClass, extensionImplClass);
        return this;
    }

    public boolean isOverriden(Class<?> extensionClass) {
        return this.isCached(extensionClass);
    }

    private <T extends Assignable> T createFromLoadExtension(Class<T> extensionClass, Archive<?> archive) {
        Class<T> extensionImplClass = this.loadExtension(extensionClass);
        if (!extensionClass.isAssignableFrom(extensionImplClass)) {
            throw new RuntimeException("Found extension impl class " + extensionImplClass.getName() + " not assignable to extension interface " + extensionClass.getName());
        }
        return this.createExtension(extensionImplClass, archive);
    }

    private <T extends Assignable> Class<T> loadExtension(Class<T> extensionClass) {
        URL extensionImplUrl = this.findExtensionImpl(extensionClass);
        String extensionImplClassName = this.loadExtensionName(extensionImplUrl);
        return this.loadExtensionClass(extensionImplClassName);
    }

    private <T extends Assignable> URL findExtensionImpl(Class<T> extensionClass) {
        try {
            Enumeration<URL> urls = this.getClassLoader().getResources("META-INF/services/" + extensionClass.getName());
            ArrayList<URL> foundExtensions = Collections.list(urls);
            if (foundExtensions.size() == 0) {
                throw new RuntimeException("No extension implementation found for " + extensionClass.getName() + ", please verify classpath or add a extensionOverride");
            }
            if (foundExtensions.size() > 1) {
                log.warning("Multiple extension implementations found for " + extensionClass.getName() + ", please verify classpath or add a extensionOverride");
            }
            return (URL)foundExtensions.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find any mapping for extension " + extensionClass.getName(), e);
        }
    }

    private String loadExtensionName(URL extensionURL) {
        try {
            return new String(IOUtil.asByteArray(extensionURL.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read extension mapping " + extensionURL, e);
        }
    }

    private <T extends Assignable> Class<T> loadExtensionClass(String extensionClassName) {
        try {
            return this.getClassLoader().loadClass(extensionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class " + extensionClassName, e);
        }
    }

    private <T extends Assignable> T createExtension(Class<T> extensionImplClass, Archive<?> archive) {
        try {
            Constructor<T> extensionImplConstructor = this.findConstructor(extensionImplClass);
            Class<?> constructorArg = extensionImplConstructor.getParameterTypes()[0];
            if (constructorArg.isInstance(archive)) {
                return (T)((Assignable)extensionImplConstructor.newInstance(archive));
            }
            return (T)((Assignable)extensionImplConstructor.newInstance(this.load(constructorArg, archive)));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + extensionImplClass, e);
        }
    }

    private <T extends Assignable> Constructor<T> findConstructor(Class<T> extensionImplClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = SecurityActions.getConstructors(extensionImplClass)) {
            Class<?> parameter;
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != 1 || !Archive.class.isAssignableFrom(parameter = parameters[0])) continue;
            return constructor;
        }
        throw new RuntimeException("No constructor with a single argument of type " + Archive.class.getName() + " could be found");
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

