/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.exporter.FutureCompletionInputStream;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.jboss.shrinkwrap.impl.base.io.StreamTask;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

public class JdkZipExporterDelegate
extends AbstractExporterDelegate<InputStream> {
    private static final Logger log = Logger.getLogger(JdkZipExporterDelegate.class.getName());
    private static final ExecutorService service = Executors.newCachedThreadPool();
    private ZipOutputStream zipOutputStream;
    private InputStream inputStream;
    private Set<ArchivePath> pathsExported = new HashSet<ArchivePath>();
    private final CountDownLatch latch = new CountDownLatch(1);

    public JdkZipExporterDelegate(Archive<?> archive) throws IllegalArgumentException {
        super(archive);
        if (archive.getContent().isEmpty()) {
            throw new IllegalArgumentException("[SHRINKWRAP-93] Cannot use this JDK-based implementation to export as ZIP an archive with no content: " + archive.toString());
        }
    }

    @Override
    protected void export() {
        PipedOutputStream output;
        Callable<Void> exportTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    JdkZipExporterDelegate.super.export();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception encountered during export of archive", e);
                    throw e;
                }
                finally {
                    try {
                        JdkZipExporterDelegate.this.zipOutputStream.close();
                    }
                    catch (IOException ioe) {
                        log.log(Level.WARNING, "[SHRINKWRAP-120] Possible deadlock scenario: Got exception on closing the ZIP out stream: " + ioe.getMessage(), ioe);
                    }
                }
                return null;
            }
        };
        Future<Void> job = service.submit(exportTask);
        FutureCompletionInputStream input = new FutureCompletionInputStream(job);
        this.inputStream = input;
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error in setting up output stream", e);
        }
        this.zipOutputStream = new ZipOutputStream(output);
        this.latch.countDown();
    }

    @Override
    protected void processAsset(final ArchivePath path, Asset asset) {
        InputStream assetStream;
        if (path == null) {
            throw new IllegalArgumentException("Path must be specified");
        }
        if (asset == null) {
            throw new IllegalArgumentException("asset must be specified");
        }
        if (this.isParentOfAnyPathsExported(path)) {
            return;
        }
        ArchivePath parent = PathUtil.getParent(path);
        if (parent != null && !this.pathsExported.contains(parent)) {
            boolean isRoot;
            ArchivePath grandParent = PathUtil.getParent(parent);
            boolean bl = isRoot = grandParent == null;
            if (!isRoot) {
                this.processAsset(parent, DirectoryAsset.INSTANCE);
            }
        }
        final boolean isDirectory = (assetStream = asset.openStream()) == null;
        final String pathName = PathUtil.optionallyRemovePrecedingSlash(path.get());
        if (!this.pathsExported.contains(path)) {
            IOUtil.closeOnComplete(assetStream, new StreamTask<InputStream>(){

                @Override
                public void execute(InputStream stream) throws Exception {
                    String resolvedPath = pathName;
                    if (isDirectory) {
                        resolvedPath = PathUtil.optionallyAppendSlash(resolvedPath);
                    }
                    ZipEntry entry = new ZipEntry(resolvedPath);
                    JdkZipExporterDelegate.this.latch.await();
                    try {
                        JdkZipExporterDelegate.this.zipOutputStream.putNextEntry(entry);
                    }
                    catch (ZipException ze) {
                        log.log(Level.SEVERE, JdkZipExporterDelegate.this.pathsExported.toString());
                        throw new RuntimeException(ze);
                    }
                    JdkZipExporterDelegate.this.pathsExported.add(path);
                    if (!isDirectory) {
                        IOUtil.copy(stream, JdkZipExporterDelegate.this.zipOutputStream);
                    }
                    JdkZipExporterDelegate.this.zipOutputStream.closeEntry();
                }
            }, new StreamErrorHandler(){

                @Override
                public void handle(Throwable t) {
                    throw new ArchiveExportException("Failed to write asset to Zip: " + pathName, t);
                }
            });
        }
    }

    @Override
    protected InputStream getResult() {
        return this.inputStream;
    }

    private boolean isParentOfAnyPathsExported(ArchivePath path) {
        for (ArchivePath exportedPath : this.pathsExported) {
            if (!this.isParentOfSpecifiedHierarchy(path, exportedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOfSpecifiedHierarchy(ArchivePath path, ArchivePath compare) {
        ArchivePath parent = PathUtil.getParent(compare);
        if (parent == null) {
            return false;
        }
        if (path.equals(compare)) {
            return true;
        }
        return this.isParentOfSpecifiedHierarchy(path, parent);
    }
}

