/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.SecurityActions;

public final class Archives {
    private static final String ARCHIVE_IMPL = "org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl";
    private static final String EXTENSION_LOADER_IMPL = "org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader";
    private static ExtensionLoader extensionLoader = null;

    public static <T extends Assignable> T create(String archiveName, Class<T> type) {
        if (archiveName == null) {
            throw new IllegalArgumentException("ArchiveName must be specified");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        Archives.initializeExtensionLoader();
        Archive archive = SecurityActions.newInstance(ARCHIVE_IMPL, new Class[]{String.class, ExtensionLoader.class}, new Object[]{archiveName, extensionLoader}, Archive.class);
        return archive.as(type);
    }

    public static <T extends Assignable> void addExtensionOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
        Archives.initializeExtensionLoader();
        extensionLoader.addOverride(extensionClass, extensionImplClass);
    }

    public static synchronized void setExtensionLoader(ExtensionLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Loader must be specified");
        }
        if (extensionLoader != null) {
            throw new IllegalStateException("Loader already specified, call setExtensionLoader before calling create or addExtensionOverride");
        }
        extensionLoader = loader;
    }

    private static synchronized void initializeExtensionLoader() {
        if (extensionLoader == null) {
            extensionLoader = SecurityActions.newInstance(EXTENSION_LOADER_IMPL, new Class[0], new Object[0], ExtensionLoader.class);
        }
    }

    static void resetState() {
        extensionLoader = null;
    }

    private Archives() {
    }
}

