/*
 * Decompiled with CFR 0.152.
 */
package org.shrinkwrap.springboot.impl.container;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipStoredExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.container.WebContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.shrinkwrap.springboot.api.container.SpringBootContainer;

public abstract class SpringBootContainerBase<T extends Archive<T>>
extends WebContainerBase<T>
implements SpringBootContainer<T> {
    private static String NO_VERSION_SPECIFIED = ".";

    protected SpringBootContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract String getSpringBootLauncherClass();

    protected abstract ArchivePath getBootInfPath();

    public T setSpringBootManifest(String applicationClassName) {
        Validate.notNullOrEmpty((String)applicationClassName, (String)"ApplicationClassName must be specified");
        return this.setSpringBootManifest(applicationClassName, NO_VERSION_SPECIFIED);
    }

    public T setSpringBootManifest(String applicationClassName, String springBootVersion) {
        Validate.notNullOrEmpty((String)applicationClassName, (String)"ApplicationClassName must be specified");
        Validate.notNullOrEmpty((String)springBootVersion, (String)"springBootVersion must be specified and can not contain null values");
        ManifestDescriptor manifest = (ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).mainClass(this.getSpringBootLauncherClass())).attribute("Start-Class", applicationClassName)).attribute("Spring-Boot-Lib", this.getLibraryPath().get())).attribute("Spring-Boot-Classes", this.getClassesPath().get());
        if (!NO_VERSION_SPECIFIED.equals(springBootVersion)) {
            manifest.attribute("Spring-Boot-Version", springBootVersion);
        }
        return (T)this.setManifest((Asset)new StringAsset(manifest.exportAsString()));
    }

    public T addAsBootInfResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull((Object)resourceName, (String)"ResourceName should be specified");
        return this.addAsBootInfResource((Asset)new ClassLoaderAsset(resourceName), AssetUtil.getNameForClassloaderResource((String)resourceName));
    }

    public T addAsBootInfResource(File resource) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        return this.addAsBootInfResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsBootInfResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull((Object)resourceName, (String)"ResourceName should be specified");
        Validate.notNull((Object)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsBootInfResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNullOrEmpty((String)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new FileAsset(resource), target);
    }

    public T addAsBootInfResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNullOrEmpty((String)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsBootInfResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNullOrEmpty((String)target, (String)"Target should be specified");
        return this.addAsBootInfResource(resource, ArchivePaths.create((String)target));
    }

    public T addAsBootInfResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull((Object)resourceName, (String)"ResourceName should be specified");
        Validate.notNull((Object)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsBootInfResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNull((Object)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new FileAsset(resource), target);
    }

    public T addAsBootInfResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNull((Object)target, (String)"Target should be specified");
        return this.addAsBootInfResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsBootInfResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        Validate.notNull((Object)target, (String)"Target should be specified");
        BasicPath location = new BasicPath(this.getBootInfPath(), target);
        return (T)this.add(resource, (ArchivePath)location);
    }

    public T addAsBootInfResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull((Object)resourcePackage, (String)"ResourcePackage must be specified");
        Validate.notNullAndNoNullValues((Object[])resourceNames, (String)"ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsBootInfResource(resourcePackage, resourceName);
        }
        return (T)this.covarientReturn();
    }

    public T addAsBootInfResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull((Object)resourcePackage, (String)"ResourcePackage must be specified");
        Validate.notNull((Object)resourceName, (String)"ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName((Package)resourcePackage, (String)resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsBootInfResource(resourcePackage, resourceName, target);
    }

    public T addAsBootInfResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull((Object)resourcePackage, (String)"ResourcePackage must be specified");
        Validate.notNullOrEmpty((String)resourceName, (String)"ResourceName must be specified");
        Validate.notNullOrEmpty((String)target, (String)"Target must be specified");
        return this.addAsBootInfResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsBootInfResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull((Object)resourcePackage, (String)"ResourcePackage must be specified");
        Validate.notNullOrEmpty((String)resourceName, (String)"ResourceName must be specified");
        Validate.notNull((Object)target, (String)"Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName((Package)resourcePackage, (String)resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsBootInfResource((Asset)resource, target);
    }

    public T addAsLauncherLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, (String)"Archive must be specified");
        return (T)this.merge(archive, path -> !path.get().startsWith("/META-INF"));
    }

    public T addAsLauncherLibraries(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, (String)"Archives must be specified");
        for (Archive<?> archive : archives) {
            this.addAsLauncherLibrary(archive);
        }
        return (T)this.covarientReturn();
    }

    public T addAsLauncherLibraries(Collection<? extends Archive<?>> archives) throws IllegalArgumentException {
        Validate.notNull(archives, (String)"Archives must be specified");
        return this.addAsLauncherLibraries((Archive<?>[])archives.toArray(new Archive[archives.size()]));
    }

    public T addAsLauncherLibraries(Archive<?>[] ... archives) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(archives, (String)"Archives must be specified");
        Archive<?>[][] archiveArray = archives;
        int n = archiveArray.length;
        for (int i = 0; i < n; ++i) {
            Archive<?>[] archiveArray2;
            for (Archive<?> archive : archiveArray2 = archiveArray[i]) {
                this.addAsLauncherLibrary(archive);
            }
        }
        return (T)this.covarientReturn();
    }

    public T addAsLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, (String)"Archive must be specified");
        return (T)this.add(archive, this.getLibraryPath(), ZipStoredExporter.class);
    }

    public T addAsServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        this.asJAR().addAsServiceProvider(serviceInterface, (Class[])serviceImpls);
        return (T)this.covarientReturn();
    }

    public T addAsServiceProvider(String serviceInterface, String ... serviceImpls) throws IllegalArgumentException {
        this.asJAR().addAsServiceProvider(serviceInterface, serviceImpls);
        return (T)this.covarientReturn();
    }

    public T addAsServiceProviderAndClasses(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        this.asJAR().addAsServiceProvider(serviceInterface, (Class[])serviceImpls);
        return (T)this.covarientReturn();
    }

    public T addLauncherClass(Class<?> clazz) throws IllegalArgumentException {
        this.asJAR().addClass(clazz);
        return (T)this.covarientReturn();
    }

    public T addLauncherClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        this.asJAR().addClass(fullyQualifiedClassName);
        return (T)this.covarientReturn();
    }

    public T addLauncherClass(String fullyQualifiedClassName, ClassLoader cl) throws IllegalArgumentException {
        this.asJAR().addClass(fullyQualifiedClassName, cl);
        return (T)this.covarientReturn();
    }

    public T addLauncherClasses(Class<?>[] classes) throws IllegalArgumentException {
        this.asJAR().addClasses((Class[])classes);
        return (T)this.covarientReturn();
    }

    public T addDefaultLauncherPackage() {
        this.asJAR().addDefaultPackage();
        return (T)this.covarientReturn();
    }

    public T addLauncherPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        this.asJAR().addPackages(recursive, packages);
        return (T)this.covarientReturn();
    }

    public T addLauncherPackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        this.asJAR().addPackages(recursive, filter, packages);
        return (T)this.covarientReturn();
    }

    public T addLauncherPackage(String pack) throws IllegalArgumentException {
        this.asJAR().addPackage(pack);
        return (T)this.covarientReturn();
    }

    public T addLauncherPackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        return null;
    }

    public T addLauncherPackages(boolean recursive, Filter<ArchivePath> filter, String ... packages) throws IllegalArgumentException {
        this.asJAR().addPackages(recursive, filter, packages);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherClass(Class<?> clazz) throws IllegalArgumentException {
        this.asJAR().deleteClass(clazz);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        this.asJAR().deleteClass(fullyQualifiedClassName);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherClasses(Class<?>[] classes) throws IllegalArgumentException {
        this.asJAR().deleteClasses((Class[])classes);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackage(Package pack) throws IllegalArgumentException {
        this.asJAR().deletePackage(pack);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackage(String pack) throws IllegalArgumentException {
        this.asJAR().deletePackage(pack);
        return (T)this.covarientReturn();
    }

    public T deleteDefaultLauncherPackage() {
        this.asJAR().deleteDefaultPackage();
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        this.asJAR().deletePackages(recursive, packages);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        this.asJAR().deletePackages(recursive, packages);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        this.asJAR().deletePackages(recursive, filter, packages);
        return (T)this.covarientReturn();
    }

    public T deleteLauncherPackages(boolean recursive, Filter<ArchivePath> filter, String ... packages) throws IllegalArgumentException {
        this.asJAR().deletePackages(recursive, filter, packages);
        return (T)this.covarientReturn();
    }

    private JavaArchive asJAR() {
        return (JavaArchive)this.as(JavaArchive.class);
    }
}

