/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLogger
extends MarkerIgnoringBase
implements Serializable,
LocationAwareLogger {
    private final Logger logger;
    private static final String LOGGER_CLASS_NAME = Slf4jLogger.class.getName();
    private static final long serialVersionUID = -8422185592693034532L;
    private static final int ALT_ERROR_INT = Level.ERROR.intValue();
    private static final int ALT_WARN_INT = Level.WARN.intValue();
    private static final int ALT_INFO_INT = Level.INFO.intValue();
    private static final int ALT_DEBUG_INT = Level.DEBUG.intValue();
    private static final int ALT_TRACE_INT = Level.TRACE.intValue();

    public Slf4jLogger(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public void log(Marker marker, String fqcn, int levelVal, String message, Throwable t) {
        Level level;
        switch (levelVal) {
            case 0: {
                level = Level.TRACE;
                break;
            }
            case 10: {
                level = Level.DEBUG;
                break;
            }
            case 20: {
                level = Level.INFO;
                break;
            }
            case 30: {
                level = Level.WARN;
                break;
            }
            case 40: {
                level = Level.ERROR;
                break;
            }
            default: {
                level = Level.DEBUG;
            }
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)level, message, fqcn);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    public void trace(String msg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.logger.logRaw(new ExtLogRecord((java.util.logging.Level)Level.TRACE, msg, LOGGER_CLASS_NAME));
    }

    public void trace(String format, Object arg) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.TRACE, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg});
        this.logger.logRaw(rec);
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.TRACE, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg1, arg2});
        this.logger.logRaw(rec);
    }

    public void trace(String format, Object[] argArray) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.TRACE, format, LOGGER_CLASS_NAME);
        rec.setParameters(argArray);
        this.logger.logRaw(rec);
    }

    public void trace(String msg, Throwable t) {
        if (ALT_TRACE_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.TRACE, msg, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    public void debug(String msg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.logger.logRaw(new ExtLogRecord((java.util.logging.Level)Level.DEBUG, msg, LOGGER_CLASS_NAME));
    }

    public void debug(String format, Object arg) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.DEBUG, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg});
        this.logger.logRaw(rec);
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.DEBUG, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg1, arg2});
        this.logger.logRaw(rec);
    }

    public void debug(String format, Object[] argArray) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.DEBUG, format, LOGGER_CLASS_NAME);
        rec.setParameters(argArray);
        this.logger.logRaw(rec);
    }

    public void debug(String msg, Throwable t) {
        if (ALT_DEBUG_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.DEBUG, msg, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.INFO);
    }

    public void info(String msg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.logger.logRaw(new ExtLogRecord((java.util.logging.Level)Level.INFO, msg, LOGGER_CLASS_NAME));
    }

    public void info(String format, Object arg) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.INFO, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg});
        this.logger.logRaw(rec);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.INFO, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg1, arg2});
        this.logger.logRaw(rec);
    }

    public void info(String format, Object[] argArray) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.INFO, format, LOGGER_CLASS_NAME);
        rec.setParameters(argArray);
        this.logger.logRaw(rec);
    }

    public void info(String msg, Throwable t) {
        if (ALT_INFO_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.INFO, msg, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.WARN);
    }

    public void warn(String msg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.logger.logRaw(new ExtLogRecord((java.util.logging.Level)Level.WARN, msg, LOGGER_CLASS_NAME));
    }

    public void warn(String format, Object arg) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.WARN, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg});
        this.logger.logRaw(rec);
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.WARN, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg1, arg2});
        this.logger.logRaw(rec);
    }

    public void warn(String format, Object[] argArray) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.WARN, format, LOGGER_CLASS_NAME);
        rec.setParameters(argArray);
        this.logger.logRaw(rec);
    }

    public void warn(String msg, Throwable t) {
        if (ALT_WARN_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.WARN, msg, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable((java.util.logging.Level)Level.ERROR);
    }

    public void error(String msg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        this.logger.logRaw(new ExtLogRecord((java.util.logging.Level)Level.ERROR, msg, LOGGER_CLASS_NAME));
    }

    public void error(String format, Object arg) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.ERROR, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg});
        this.logger.logRaw(rec);
    }

    public void error(String format, Object arg1, Object arg2) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.ERROR, format, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{arg1, arg2});
        this.logger.logRaw(rec);
    }

    public void error(String format, Object[] argArray) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.ERROR, format, LOGGER_CLASS_NAME);
        rec.setParameters(argArray);
        this.logger.logRaw(rec);
    }

    public void error(String msg, Throwable t) {
        if (ALT_ERROR_INT < this.logger.getEffectiveLevel()) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord((java.util.logging.Level)Level.ERROR, msg, LOGGER_CLASS_NAME);
        rec.setThrown(t);
        this.logger.logRaw(rec);
    }

    protected Slf4jLogger readResolve() throws ObjectStreamException {
        return this;
    }
}

