/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.logging.internal;

import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.solder.logging.internal.Logger;

final class JBossLogManagerLogger
extends Logger {
    private static final long serialVersionUID = 7429618317727584742L;
    private final org.jboss.logmanager.Logger logger;

    JBossLogManagerLogger(String name, org.jboss.logmanager.Logger logger) {
        super(name);
        this.logger = logger;
    }

    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable(JBossLogManagerLogger.translate(level));
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        if (parameters == null) {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), String.valueOf(message), thrown);
        } else {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), String.valueOf(message), ExtLogRecord.FormatStyle.MESSAGE_FORMAT, parameters, thrown);
        }
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (parameters == null) {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), format, thrown);
        } else {
            this.logger.log(loggerClassName, JBossLogManagerLogger.translate(level), format, ExtLogRecord.FormatStyle.PRINTF, parameters, thrown);
        }
    }

    private static java.util.logging.Level translate(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return Level.FATAL;
                }
                case ERROR: {
                    return Level.ERROR;
                }
                case WARN: {
                    return Level.WARN;
                }
                case INFO: {
                    return Level.INFO;
                }
                case DEBUG: {
                    return Level.DEBUG;
                }
                case TRACE: {
                    return Level.TRACE;
                }
            }
        }
        return Level.ALL;
    }
}

