/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.logging.internal;

import java.util.logging.LogManager;
import org.jboss.solder.logging.internal.JBossLogManagerProvider;
import org.jboss.solder.logging.internal.JDKLoggerProvider;
import org.jboss.solder.logging.internal.Log4jLoggerProvider;
import org.jboss.solder.logging.internal.LoggerProvider;
import org.jboss.solder.logging.internal.Slf4jLoggerProvider;

final class LoggerProviders {
    static final LoggerProvider PROVIDER = LoggerProviders.findProvider();

    private static LoggerProvider findProvider() {
        LogManager jdkLogManager = LogManager.getLogManager();
        if (jdkLogManager.getClass().getName().equals("org.jboss.logmanager.LogManager")) {
            return new JBossLogManagerProvider();
        }
        ClassLoader cl = LoggerProviders.getClassLoader();
        try {
            Class.forName("org.apache.log4j.LogManager", true, cl);
            return new Log4jLoggerProvider();
        }
        catch (Throwable t) {
            try {
                Class.forName("ch.qos.logback.classic.Logger", false, cl);
                return new Slf4jLoggerProvider();
            }
            catch (Throwable throwable) {
                return new JDKLoggerProvider();
            }
        }
    }

    private static ClassLoader getClassLoader() {
        return LoggerProviders.class.getClassLoader();
    }

    private LoggerProviders() {
    }
}

