/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.stdio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final ByteBuffer inputBuffer;
    private final CharBuffer outputBuffer;

    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset());
    }

    public WriterOutputStream(Writer writer, String charsetName) {
        this(writer, Charset.forName(charsetName));
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset.newDecoder());
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder) {
        this.writer = writer;
        this.decoder = decoder;
        this.inputBuffer = ByteBuffer.allocate(256);
        this.outputBuffer = CharBuffer.allocate(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        CharsetDecoder charsetDecoder = this.decoder;
        synchronized (charsetDecoder) {
            ByteBuffer inputBuffer = this.inputBuffer;
            inputBuffer.put((byte)b);
            if (!inputBuffer.hasRemaining()) {
                this.flush();
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        CharsetDecoder charsetDecoder = this.decoder;
        synchronized (charsetDecoder) {
            while (true) {
                ByteBuffer inputBuffer;
                int rem;
                int cnt = (rem = (inputBuffer = this.inputBuffer).remaining()) <= len ? rem : len;
                inputBuffer.put(b, off, cnt);
                off += cnt;
                if ((len -= cnt) == 0) {
                    return;
                }
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        CharsetDecoder charsetDecoder = this.decoder;
        synchronized (charsetDecoder) {
            CharBuffer outputBuffer = this.outputBuffer;
            ByteBuffer inputBuffer = this.inputBuffer;
            inputBuffer.flip();
            while (true) {
                CoderResult coderResult;
                if ((coderResult = this.decoder.decode(inputBuffer, outputBuffer, false)).isOverflow()) {
                    outputBuffer.flip();
                    boolean ok = false;
                    try {
                        this.writer.write(outputBuffer.array(), outputBuffer.arrayOffset(), outputBuffer.remaining());
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            inputBuffer.clear();
                        }
                        outputBuffer.clear();
                    }
                    continue;
                }
                if (coderResult.isUnderflow()) break;
            }
            inputBuffer.compact();
            return;
        }
    }

    public void close() throws IOException {
        this.flush();
    }
}

