/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.ResourceProvider;

public class ResourceProviderRegistry {
    private Map<Class<?>, ResourceProvider<?, ? extends EnvironmentEntryType>> bindingProviders = new ConcurrentHashMap();

    public void registerProviders(Collection<ResourceProvider<?, ? extends EnvironmentEntryType>> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("ENCBindingProvider(s) cannot be null during registration");
        }
        for (ResourceProvider<?, EnvironmentEntryType> resourceProvider : providers) {
            this.registerProvider(resourceProvider);
        }
    }

    public void registerProvider(ResourceProvider<?, ? extends EnvironmentEntryType> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("ENCBindingProvider cannot be null during registration");
        }
        Class type = provider.getEnvironmentEntryType();
        this.bindingProviders.put(type, provider);
    }

    public ResourceProvider<?, ? extends EnvironmentEntryType> getResourceProvider(Class<? extends EnvironmentEntryType> type) {
        Class<?>[] interfaces;
        ResourceProvider<?, ? extends EnvironmentEntryType> provider = this.bindingProviders.get(type);
        if (provider != null) {
            return provider;
        }
        for (Class<? extends EnvironmentEntryType> entryType = type.getSuperclass(); entryType != null && EnvironmentEntryType.class.isAssignableFrom(entryType); entryType = entryType.getSuperclass()) {
            provider = this.getResourceProvider(entryType);
            if (provider == null) continue;
            return provider;
        }
        for (Class<?> intf : interfaces = type.getInterfaces()) {
            if (!EnvironmentEntryType.class.isAssignableFrom(intf) || (provider = this.getResourceProvider(intf)) == null) continue;
            return provider;
        }
        return provider;
    }
}

