/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.switchboard.jbmeta.javaee.environment;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.switchboard.javaee.environment.Handler;

/**
 * ServiceHandler
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class ServiceHandler implements Handler
{

   private ServiceReferenceHandlerMetaData delegate;
   
   public ServiceHandler(ServiceReferenceHandlerMetaData delegate)
   {
      this.delegate = delegate;
   }
   @Override
   public String getHandlerClass()
   {
      return this.delegate.getHandlerClass();
   }

   @Override
   public Map<String, String> getInitParams()
   {
      List<ParamValueMetaData> params = this.delegate.getInitParam();
      if (params == null)
      {
         return null;
      }
      Map<String, String> initParams = new HashMap<String, String>(params.size());
      for (ParamValueMetaData param : params)
      {
         initParams.put(param.getParamName(), param.getParamValue()); 
      }
      return initParams;
   }

   @Override
   public Collection<String> getPortNames()
   {
      return this.delegate.getPortName();
   }

   @Override
   public Collection<QName> getSoapHeaders()
   {
      return this.delegate.getSoapHeader();
   }

   @Override
   public Collection<String> getSoapRoles()
   {
      return this.delegate.getSoapRole();
   }
   @Override
   public String getHandlerName()
   {
      return this.delegate.getHandlerName();
   }
   
   
}
 