/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.switchboard.jbmeta.javaee.jboss.environment;

import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.switchboard.javaee.jboss.environment.JBossResourceEnvRefType;
import org.jboss.switchboard.javaee.util.EnvironmentEntryUtil;
import org.jboss.switchboard.jbmeta.javaee.environment.InjectionTargetConverter;
import org.jboss.switchboard.jbmeta.javaee.environment.JavaEEResource;

/**
 * ResourceEnvReference
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class JBossResourceEnvReference extends JavaEEResource implements JBossResourceEnvRefType
{

   private ResourceEnvironmentReferenceMetaData delegate;
   
   public JBossResourceEnvReference(ResourceEnvironmentReferenceMetaData delegate)
   {
      super(delegate.getLookupName(), delegate.getMappedName(), InjectionTargetConverter.convert(delegate
            .getInjectionTargets()));
      this.delegate = delegate;
   }
   
   @Override
   public String getResourceType()
   {
      return this.delegate.getType();
   }

   @Override
   public String getName()
   {
      return EnvironmentEntryUtil.getENCName(this.delegate.getResourceEnvRefName());
   }

   @Override
   public String getJNDIName()
   {
      return this.delegate.getJndiName();
   }

   @Override
   public boolean isIgnoreDependency()
   {
      return this.delegate.isDependencyIgnored();
   }

}
