/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.switchboard.jbmeta.javaee.jboss.environment;

import java.util.ArrayList;
import java.util.List;

import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.JBossServiceReferenceMetaData;
import org.jboss.switchboard.javaee.jboss.environment.JBossPortComponent;
import org.jboss.switchboard.javaee.jboss.environment.JBossServiceRefType;
import org.jboss.switchboard.jbmeta.javaee.environment.ServiceReference;

/**
 * JBossServiceReference
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class JBossServiceReference extends ServiceReference implements JBossServiceRefType
{

   private JBossServiceReferenceMetaData delegate;

   public JBossServiceReference(JBossServiceReferenceMetaData delegate)
   {
      super(delegate);
      this.delegate = delegate;
   }

   @Override
   public String getServiceClass()
   {
      return delegate.getServiceClass();
   }

   @Override
   public String getConfigName()
   {
      return delegate.getConfigName();
   }

   @Override
   public String getConfigFile()
   {
      return delegate.getConfigFile();
   }

   @Override
   public String getHandlerChain()
   {
      return delegate.getHandlerChain();
   }

   @Override
   public String getWsdlOverride()
   {
      return delegate.getWsdlOverride();
   }

   @Override
   public List<JBossPortComponent> getJBossPortComponents()
   {
      List<JBossPortComponentRef> jbpcrList = this.delegate.getJBossPortComponentRef();
      if (jbpcrList == null)
      {
         return null;
      }
      List<JBossPortComponent> portComponentRefs = new ArrayList<JBossPortComponent>(jbpcrList.size());
      for (JBossPortComponentRef jbpcr : jbpcrList)
      {
         portComponentRefs.add(new JBossPortComponentImpl(jbpcr));
      }
      return portComponentRefs;
   }

}
