/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.switchboard.impl.ENCOperator;
import org.jboss.switchboard.mc.dependency.SwitchBoardDependencyMetaData;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.switchboard.spi.Resource;

public class SwitchBoardImpl
implements Barrier {
    private String id;
    private ENCOperator encOperator;
    private JavaEEComponent javaEEComponent;
    private DeploymentUnit unit;

    public SwitchBoardImpl(String barrierId, ENCOperator encOperator, DeploymentUnit unit) {
        this.id = barrierId;
        this.encOperator = encOperator;
        this.unit = unit;
    }

    public void start() throws NamingException {
        this.encOperator.bind();
    }

    public void stop() throws NamingException {
        this.encOperator.unbind();
    }

    public JavaEEComponent getJavaEEComponent() {
        return this.javaEEComponent;
    }

    public void setJavaEEComponent(JavaEEComponent javaComp) {
        this.encOperator.setContext(javaComp.getContext());
        this.javaEEComponent = javaComp;
    }

    public void setJavaEEModule(final JavaEEModule javaeeModule) {
        JavaEEComponent javaComp = new JavaEEComponent(){

            public String getName() {
                return javaeeModule.getName();
            }

            public JavaEEModule getModule() {
                return javaeeModule;
            }

            public Context getContext() {
                return javaeeModule.getContext();
            }
        };
        this.setJavaEEComponent(javaComp);
    }

    public Context getContext() {
        return this.javaEEComponent == null ? null : this.javaEEComponent.getContext();
    }

    public String getId() {
        return this.id;
    }

    public void addENCBinding(Map<String, Resource> resources) {
        this.encOperator.addENCBinding(resources);
    }

    public Collection<DependencyMetaData> getDependencies() {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        for (Resource encBinding : this.encOperator.getENCBindings().values()) {
            Object dependency = encBinding.getDependency();
            if (dependency == null) continue;
            SwitchBoardDependencyMetaData mcDependency = new SwitchBoardDependencyMetaData(this, dependency);
            dependencies.add((DependencyMetaData)mcDependency);
        }
        return dependencies;
    }

    public ClassLoader getClassLoader() {
        return this.unit.getClassLoader();
    }
}

