/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.dependency;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.CurrentComponent;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.switchboard.mc.SwitchBoardImpl;

public class JNDIDependencyItem
extends AbstractDependencyItem
implements NamespaceChangeListener {
    private static Logger logger = Logger.getLogger(JNDIDependencyItem.class);
    private SwitchBoardImpl switchBoard;
    private String jndiName;
    private Context globalContext;

    public JNDIDependencyItem(SwitchBoardImpl switchBoard, String jndiName) {
        this(switchBoard, jndiName, false);
    }

    public JNDIDependencyItem(SwitchBoardImpl switchBoard, String jndiName, boolean resolved) {
        super((Object)jndiName, (Object)jndiName, ControllerState.CREATE, ControllerState.INSTALLED);
        this.switchBoard = switchBoard;
        this.jndiName = jndiName;
        this.setResolved(resolved);
        this.tryRegisterNamingListener();
    }

    public boolean resolve(Controller controller) {
        if (this.isResolved()) {
            return true;
        }
        JavaEEComponent javaeeComp = this.switchBoard.getJavaEEComponent();
        if (javaeeComp == null) {
            this.setResolved(false);
            return this.isResolved();
        }
        CurrentComponent.push((JavaEEComponent)javaeeComp);
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.switchBoard.getClassLoader());
        try {
            this.getGlobalContext().lookup(this.jndiName);
            this.setResolved(true);
            logger.debug((Object)("Resolved jndi-name dependency: " + this.jndiName + " based on jndi lookup for switchboard: " + this.switchBoard.getId()));
        }
        catch (NameNotFoundException nnfe) {
            this.setResolved(false);
        }
        catch (NamingException ne) {
            throw new RuntimeException("Exception during resolving jndi dependency for jndi name: " + this.jndiName + " for JavaEEComponent " + javaeeComp.getName(), ne);
        }
        finally {
            CurrentComponent.pop();
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return this.isResolved();
    }

    @Override
    public void objectAdded(NamingEvent namingEvent) {
        Binding binding = namingEvent.getNewBinding();
        String boundJNDIName = binding.getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + " received OBJECT_ADDED event for jndi-name: " + boundJNDIName));
        }
        if (this.jndiName.equals(boundJNDIName)) {
            this.setResolved(true);
            logger.debug((Object)("Resolved jndi-name dependency: " + this.jndiName + " based on naming event for switchboard: " + this.switchBoard.getId()));
        }
    }

    @Override
    public void objectRemoved(NamingEvent namingEvent) {
        Binding binding = namingEvent.getNewBinding();
        String removedJNDIName = binding.getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this + " received OBJECT_REMOVED event for jndi-name: " + removedJNDIName));
        }
        if (this.jndiName.equals(removedJNDIName)) {
            this.setResolved(false);
            logger.debug((Object)("Naming event received, jndi-name dependency: " + this.jndiName + " un-bound for switchboard: " + this.switchBoard.getId()));
        }
    }

    @Override
    public void objectRenamed(NamingEvent evt) {
    }

    @Override
    public void namingExceptionThrown(NamingExceptionEvent evt) {
        logger.error((Object)("NamingException thrown while listening for jndi binding events for jndi name: " + this.jndiName), (Throwable)evt.getException());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[jndi-name:");
        sb.append(this.jndiName);
        sb.append("switchboard id:");
        sb.append(this.switchBoard.getId());
        sb.append("]");
        return sb.toString();
    }

    private Context getGlobalContext() throws NamingException {
        if (this.globalContext == null) {
            this.globalContext = new InitialContext();
        }
        return this.globalContext;
    }

    private void tryRegisterNamingListener() {
        block3: {
            try {
                Context globalCtx = this.getGlobalContext();
                Context ctx = (Context)globalCtx.lookup("");
                if (ctx instanceof EventContext) {
                    EventContext eventCtx = (EventContext)ctx;
                    eventCtx.addNamingListener(this.jndiName, 2, (NamingListener)this);
                    logger.debug((Object)("Using naming event based dependency resolver for jndi-name: " + this.jndiName + " for switchboard: " + this.switchBoard.getId()));
                }
            }
            catch (Throwable t) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace((Object)("**** Exception stacktrace can be ignored **** Could not register naming listener for jndi-name: " + this.jndiName + " for switchboard: " + this.switchBoard.getId()), t);
            }
        }
    }
}

