/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.deployer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.jbmeta.javaee.environment.BeanManagerReference;
import org.jboss.switchboard.jbmeta.javaee.environment.JndiEnvironmentMetadata;
import org.jboss.switchboard.jbmeta.javaee.environment.ORBReference;
import org.jboss.switchboard.jbmeta.javaee.environment.TransactionSynchronizationRegistryReference;
import org.jboss.switchboard.jbmeta.javaee.environment.UserTransactionReference;
import org.jboss.switchboard.jbmeta.javaee.environment.ValidatorFactoryReference;
import org.jboss.switchboard.jbmeta.javaee.environment.ValidatorReference;
import org.jboss.switchboard.mc.JndiEnvironmentProcessor;
import org.jboss.switchboard.mc.SwitchBoardImpl;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.JndiEnvironment;
import org.jboss.switchboard.spi.Resource;

public abstract class AbstractSwitchBoardDeployer
extends AbstractRealDeployer {
    private static Logger logger = Logger.getLogger(AbstractSwitchBoardDeployer.class);
    protected JavaEEComponentInformer informer;
    protected JndiEnvironmentProcessor jndiEnvProcessor;

    public AbstractSwitchBoardDeployer(JavaEEComponentInformer informer) {
        this.informer = informer;
        this.setOutput(BeanMetaData.class);
        this.addOutput(Barrier.class);
    }

    @Inject
    public void setJNDIEnvironmentProcessor(JndiEnvironmentProcessor processor) {
        this.jndiEnvProcessor = processor;
    }

    protected String getApplicationName(DeploymentUnit deploymentUnit) {
        return this.informer.getApplicationName(deploymentUnit);
    }

    protected String getComponentName(DeploymentUnit deploymentUnit) {
        return this.informer.getComponentName(deploymentUnit);
    }

    protected String getModuleName(DeploymentUnit deploymentUnit) {
        return this.informer.getModuleName(deploymentUnit);
    }

    protected void process(DeploymentUnit unit, Collection<Environment> environments) {
        BeanMetaData switchBoardBMD;
        Barrier barrier;
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        if (environments != null) {
            for (Environment env : environments) {
                if (env == null) continue;
                JndiEnvironmentMetadata jndiEnv = new JndiEnvironmentMetadata(env);
                this.addJavaComponentEntries((JndiEnvironment)jndiEnv);
                resources.putAll(this.jndiEnvProcessor.process(unit, (JndiEnvironment)jndiEnv));
            }
        }
        if ((barrier = (Barrier)unit.getAttachment(Barrier.class)) == null) {
            SwitchBoardImpl switchBoard = new SwitchBoardImpl(this.getSwitchBoardMCBeanName(unit), resources, unit);
            this.attachBarrier(unit, switchBoard);
            switchBoardBMD = this.createSwitchBoardBMD(unit, switchBoard);
            this.attachSwitchBoardBMD(unit, switchBoardBMD);
        } else if (barrier instanceof SwitchBoardImpl) {
            SwitchBoardImpl switchboard = (SwitchBoardImpl)barrier;
            switchboard.addENCBinding(resources);
            switchBoardBMD = this.createSwitchBoardBMD(unit, switchboard);
            this.attachSwitchBoardBMD(unit, switchBoardBMD);
        }
    }

    protected void addJavaComponentEntries(JndiEnvironment jndiEnv) {
        jndiEnv.addEntry((EnvironmentEntryType)new ORBReference());
        jndiEnv.addEntry((EnvironmentEntryType)new UserTransactionReference());
        jndiEnv.addEntry((EnvironmentEntryType)new TransactionSynchronizationRegistryReference());
        jndiEnv.addEntry((EnvironmentEntryType)new BeanManagerReference());
        jndiEnv.addEntry((EnvironmentEntryType)new ValidatorReference());
        jndiEnv.addEntry((EnvironmentEntryType)new ValidatorFactoryReference());
    }

    protected BeanMetaData createSwitchBoardBMD(DeploymentUnit unit, SwitchBoardImpl switchBoard) {
        String mcBeanName = switchBoard.getId();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)mcBeanName, (String)switchBoard.getClass().getName());
        builder.setConstructorValue((Object)switchBoard);
        builder.addPropertyMetaData("javaGlobalContext", builder.createInject((Object)"NameSpaces", "globalContext"));
        AbstractInjectionValueMetaData namingContextInjection = this.getNamingContextInjectionMetaData(unit);
        if (this.informer.isJavaEEComponent(unit) && !this.isSharedENC(unit)) {
            builder.addPropertyMetaData("javaEEComponent", (ValueMetaData)namingContextInjection);
        } else {
            builder.addPropertyMetaData("javaEEModule", (ValueMetaData)namingContextInjection);
        }
        for (DependencyMetaData dependency : switchBoard.getDependencies()) {
            builder.addDependency(dependency);
        }
        if (logger.isDebugEnabled()) {
            Set supplies;
            Set demands;
            logger.debug((Object)("Installing SwitchBoard: " + mcBeanName + " for unit: " + unit.getSimpleName()));
            Set dependencies = builder.getBeanMetaData().getDepends();
            if (dependencies != null) {
                logger.debug((Object)"with dependencies:");
                for (DependencyMetaData dependency : dependencies) {
                    logger.debug((Object)dependency);
                }
            }
            if ((demands = builder.getBeanMetaData().getDemands()) != null) {
                logger.debug((Object)"demands:");
                for (DemandMetaData demand : demands) {
                    logger.debug((Object)demand);
                }
            }
            if ((supplies = builder.getBeanMetaData().getSupplies()) != null) {
                logger.debug((Object)"supplies:");
                for (SupplyMetaData supply : supplies) {
                    logger.debug((Object)supply);
                }
            }
        }
        return builder.getBeanMetaData();
    }

    protected String getSwitchBoardMCBeanName(DeploymentUnit unit) {
        StringBuilder sb = new StringBuilder("jboss-switchboard:");
        String appName = this.getApplicationName(unit);
        if (appName != null) {
            sb.append("appName=");
            sb.append(appName);
            sb.append(",");
        }
        String moduleName = this.getModuleName(unit);
        sb.append("module=");
        sb.append(moduleName);
        if (this.informer.isJavaEEComponent(unit) && !this.isSharedENC(unit)) {
            String componentName = this.getComponentName(unit);
            sb.append(",name=");
            sb.append(componentName);
        }
        return sb.toString();
    }

    protected String getENCContextMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.getApplicationName(deploymentUnit);
        String moduleName = this.getModuleName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (this.informer.isJavaEEComponent(deploymentUnit) && !this.isSharedENC(deploymentUnit)) {
            String componentName = this.getComponentName(deploymentUnit);
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    protected boolean isSharedENC(DeploymentUnit deploymentUnit) {
        JBossMetaData jbossMetaData = (JBossMetaData)deploymentUnit.getAttachment(JBossMetaData.class);
        JBossWebMetaData jbosswebMetaData = (JBossWebMetaData)deploymentUnit.getAttachment(JBossWebMetaData.class);
        return jbossMetaData != null && jbosswebMetaData != null;
    }

    protected AbstractInjectionValueMetaData getNamingContextInjectionMetaData(DeploymentUnit deploymentUnit) {
        String encCtxMCBeanName = this.getENCContextMCBeanName(deploymentUnit);
        AbstractInjectionValueMetaData namingContextInjectionMetaData = new AbstractInjectionValueMetaData((Object)encCtxMCBeanName);
        return namingContextInjectionMetaData;
    }

    protected abstract void attachSwitchBoardBMD(DeploymentUnit var1, BeanMetaData var2);

    protected abstract void attachBarrier(DeploymentUnit var1, Barrier var2);
}

