/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.environment.JavaEEResourceType;
import org.jboss.switchboard.javaee.environment.ResourceRefType;
import org.jboss.switchboard.javaee.jboss.environment.JBossResourceRefType;
import org.jboss.switchboard.javaee.util.InjectionTargetUtil;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.Resource;

public class ResourceRefResourceProviderDelegator
implements MCBasedResourceProvider<JBossResourceRefType> {
    private Map<String, MCBasedResourceProvider<JBossResourceRefType>> typedResourceRefResourceProviders = new HashMap<String, MCBasedResourceProvider<JBossResourceRefType>>();
    private Collection<MCBasedResourceProvider<JBossResourceRefType>> fallbackResourceRefResourceProviders = new ArrayList<MCBasedResourceProvider<JBossResourceRefType>>();

    public Class<JBossResourceRefType> getEnvironmentEntryType() {
        return JBossResourceRefType.class;
    }

    public Resource provide(DeploymentUnit deploymentUnit, JBossResourceRefType resRef) {
        MCBasedResourceProvider<JBossResourceRefType> resourceRefProvider;
        String resourceType = this.getResourceRefType(deploymentUnit.getClassLoader(), (ResourceRefType)resRef);
        if (resourceType != null) {
            resourceType = resourceType.trim();
        }
        if ((resourceRefProvider = this.typedResourceRefResourceProviders.get(resourceType)) != null) {
            return resourceRefProvider.provide((Object)deploymentUnit, (EnvironmentEntryType)resRef);
        }
        String lookupName = resRef.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName, resRef.isIgnoreDependency());
        }
        String mappedName = resRef.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName, resRef.isIgnoreDependency());
        }
        String jndiName = resRef.getJNDIName();
        if (jndiName != null && !jndiName.trim().isEmpty()) {
            return new LinkRefResource(jndiName, resRef.isIgnoreDependency());
        }
        for (MCBasedResourceProvider<JBossResourceRefType> provider : this.fallbackResourceRefResourceProviders) {
            Resource resource;
            if (provider == null || (resource = provider.provide((Object)deploymentUnit, (EnvironmentEntryType)resRef)) == null) continue;
            return resource;
        }
        throw new RuntimeException("Neither any mapped-name/lookup/jndi-name specified nor any ResourceProvider could process resource-ref named " + resRef.getName() + " of type " + resRef.getResourceType());
    }

    public void setTypedResourceRefResourceProviders(Map<String, MCBasedResourceProvider<JBossResourceRefType>> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("Cannot set null to typed resource-ref resource providers");
        }
        this.typedResourceRefResourceProviders = providers;
    }

    public void setFallbackResourceRefResourceProviders(Collection<MCBasedResourceProvider<JBossResourceRefType>> providers) {
        if (providers == null) {
            throw new IllegalArgumentException("Cannot set null to resource-ref resource providers");
        }
        this.fallbackResourceRefResourceProviders = providers;
    }

    private String getResourceRefType(ClassLoader cl, ResourceRefType resourceRef) {
        String explicitType = resourceRef.getResourceType();
        if (explicitType != null && !explicitType.isEmpty()) {
            return explicitType;
        }
        Class type = InjectionTargetUtil.getInjectionTargetPropertyType((ClassLoader)cl, (JavaEEResourceType)resourceRef);
        return type == null ? null : type.getName();
    }
}

