/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.switchboard.impl.ENCOperator;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.switchboard.spi.Resource;

public class SwitchBoardImpl
implements Barrier {
    private String id;
    private ENCOperator encOperator;

    public SwitchBoardImpl(String barrierId, ENCOperator encOperator) {
        this.id = barrierId;
        this.encOperator = encOperator;
    }

    public void start() throws NamingException {
        this.encOperator.bind();
    }

    public void stop() throws NamingException {
        this.encOperator.unbind();
    }

    public void setContext(Context ctx) {
        this.encOperator.setContext(ctx);
    }

    public String getId() {
        return this.id;
    }

    public void addENCBinding(Map<String, Resource> resources) {
        this.encOperator.addENCBinding(resources);
    }

    public Collection<DependencyMetaData> getDependencies() {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        for (Resource encBinding : this.encOperator.getENCBindings().values()) {
            Object dependency = encBinding.getDependency();
            if (dependency == null) continue;
            AbstractDependencyMetaData mcDependency = new AbstractDependencyMetaData(dependency);
            dependencies.add((DependencyMetaData)mcDependency);
        }
        return dependencies;
    }
}

