/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.deployer;

import java.util.Collection;
import java.util.HashMap;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.impl.ENCOperator;
import org.jboss.switchboard.impl.JndiEnvironmentProcessor;
import org.jboss.switchboard.jbmeta.javaee.environment.JndiEnvironmentMetadata;
import org.jboss.switchboard.mc.SwitchBoardImpl;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.switchboard.spi.JndiEnvironment;
import org.jboss.switchboard.spi.Resource;

public abstract class AbstractENCOperatorDeployer
extends AbstractRealDeployer {
    private static Logger logger = Logger.getLogger(AbstractENCOperatorDeployer.class);
    protected JavaEEComponentInformer informer;
    protected JndiEnvironmentProcessor jndiEnvProcessor;

    public AbstractENCOperatorDeployer(JavaEEComponentInformer informer) {
        this.informer = informer;
        this.setInputs(informer.getRequiredAttachments());
    }

    @Inject
    public void setJNDIEnvironmentProcessor(JndiEnvironmentProcessor processor) {
        this.jndiEnvProcessor = processor;
    }

    protected String getApplicationName(DeploymentUnit deploymentUnit) {
        return this.informer.getApplicationName(deploymentUnit);
    }

    protected String getComponentName(DeploymentUnit deploymentUnit) {
        return this.informer.getComponentName(deploymentUnit);
    }

    protected String getModuleName(DeploymentUnit deploymentUnit) {
        return this.informer.getModuleName(deploymentUnit);
    }

    protected void process(DeploymentUnit unit, Collection<Environment> environments) {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        for (Environment env : environments) {
            JndiEnvironment jndiEnv = this.convert(env);
            resources.putAll(this.jndiEnvProcessor.process((Object)unit, jndiEnv));
        }
        if (resources.isEmpty()) {
            return;
        }
        Barrier barrier = (Barrier)unit.getAttachment(Barrier.class);
        if (barrier == null) {
            ENCOperator encOperator = new ENCOperator(resources);
            SwitchBoardImpl switchBoard = new SwitchBoardImpl(this.getSwitchBoardMCBeanName(unit), encOperator);
            this.attachBarrier(unit, switchBoard);
            BeanMetaData switchBoardBMD = this.createSwitchBoardBMD(unit, switchBoard);
            this.attachSwitchBoardBMD(unit, switchBoardBMD);
        } else if (barrier instanceof SwitchBoardImpl) {
            SwitchBoardImpl switchboard = (SwitchBoardImpl)barrier;
            switchboard.addENCBinding(resources);
        }
    }

    private JndiEnvironment convert(Environment environment) {
        return new JndiEnvironmentMetadata(environment);
    }

    protected BeanMetaData createSwitchBoardBMD(DeploymentUnit unit, SwitchBoardImpl switchBoard) {
        String mcBeanName = switchBoard.getId();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)mcBeanName, (String)switchBoard.getClass().getName());
        builder.setConstructorValue((Object)switchBoard);
        AbstractInjectionValueMetaData namingContextInjection = this.getNamingContextInjectionMetaData(unit);
        builder.addPropertyMetaData("context", (ValueMetaData)namingContextInjection);
        logger.debug((Object)("Installing SwitchBoard: " + mcBeanName + " for unit: " + unit.getSimpleName() + " with dependencies: "));
        for (DependencyMetaData dependency : switchBoard.getDependencies()) {
            logger.debug((Object)dependency);
            builder.addDependency(dependency);
        }
        return builder.getBeanMetaData();
    }

    protected abstract void attachSwitchBoardBMD(DeploymentUnit var1, BeanMetaData var2);

    protected abstract void attachBarrier(DeploymentUnit var1, Barrier var2);

    protected abstract AbstractInjectionValueMetaData getNamingContextInjectionMetaData(DeploymentUnit var1);

    protected String getSwitchBoardMCBeanName(DeploymentUnit unit) {
        StringBuilder sb = new StringBuilder("jboss-switchboard:");
        String appName = this.getApplicationName(unit);
        if (appName != null) {
            sb.append("appName=");
            sb.append(appName);
            sb.append(",");
        }
        String moduleName = this.getModuleName(unit);
        sb.append("module=");
        sb.append(moduleName);
        if (this.informer.isJavaEEComponent(unit)) {
            String componentName = this.getComponentName(unit);
            sb.append(",name=");
            sb.append(componentName);
        }
        return sb.toString();
    }

    private String getENCContextMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.getApplicationName(deploymentUnit);
        String moduleName = this.getModuleName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (this.informer.isJavaEEComponent(deploymentUnit) && !this.isSharedENC(deploymentUnit)) {
            String componentName = this.getComponentName(deploymentUnit);
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    private boolean isSharedENC(DeploymentUnit deploymentUnit) {
        JBossMetaData jbossMetaData = (JBossMetaData)deploymentUnit.getAttachment(JBossMetaData.class);
        JBossWebMetaData jbosswebMetaData = (JBossWebMetaData)deploymentUnit.getAttachment(JBossWebMetaData.class);
        return jbossMetaData != null && jbosswebMetaData != null;
    }
}

