/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.switchboard.javaee.environment.InjectionTarget;
import org.jboss.switchboard.javaee.environment.SimpleEnvironmentEntryType;
import org.jboss.switchboard.mc.resource.IndependentResource;
import org.jboss.switchboard.mc.resource.provider.InjectionTargetUtil;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

public class EnvEntryResourceProvider
implements MCBasedResourceProvider<SimpleEnvironmentEntryType> {
    private static Logger logger = Logger.getLogger(EnvEntryResourceProvider.class);

    public Resource provide(DeploymentUnit deploymentUnit, SimpleEnvironmentEntryType envEntry) {
        ClassLoader cl = deploymentUnit.getClassLoader();
        Object targetValue = this.getEnvEntryValue(cl, envEntry);
        IndependentResource resource = new IndependentResource(targetValue);
        return resource;
    }

    public Class<SimpleEnvironmentEntryType> getEnvironmentEntryType() {
        return SimpleEnvironmentEntryType.class;
    }

    private Object getEnvEntryValue(ClassLoader cl, SimpleEnvironmentEntryType envEntry) {
        String envEntryType = this.getEnvEntryType(cl, envEntry);
        String value = envEntry.getValue();
        if (envEntryType == null) {
            return value;
        }
        if (envEntryType.equals(String.class.getName())) {
            return value;
        }
        if (envEntryType.equals(Integer.class.getName()) || envEntryType.equals(Integer.TYPE.getName())) {
            return new Integer(value);
        }
        if (envEntryType.equals(Long.class.getName()) || envEntryType.equals(Long.TYPE.getName())) {
            return new Long(value);
        }
        if (envEntryType.equals(Double.class.getName()) || envEntryType.equals(Double.TYPE.getName())) {
            return new Double(value);
        }
        if (envEntryType.equals(Float.class.getName()) || envEntryType.equals(Float.TYPE.getName())) {
            return new Float(value);
        }
        if (envEntryType.equals(Byte.class.getName()) || envEntryType.equals(Byte.TYPE.getName())) {
            return new Byte(value);
        }
        if (envEntryType.equals(Character.class.getName()) || envEntryType.equals(Character.TYPE.getName())) {
            if (value == null || value.length() == 0) {
                return new Character('\u0000');
            }
            if (value.length() > 1) {
                logger.warn((Object)("Warning character env-entry is too long: binding=" + envEntry.getName() + " value=" + value));
            }
            return new Character(value.charAt(0));
        }
        if (envEntryType.equals(Short.class.getName()) || envEntryType.equals(Short.TYPE.getName())) {
            return new Short(value);
        }
        if (envEntryType.equals(Boolean.class.getName()) || envEntryType.equals(Boolean.TYPE.getName())) {
            return new Boolean(value);
        }
        return value;
    }

    private String getEnvEntryType(ClassLoader cl, SimpleEnvironmentEntryType envEntry) {
        String explicitType = envEntry.getType();
        if (explicitType != null && !explicitType.isEmpty()) {
            return explicitType;
        }
        Collection injectionTargets = envEntry.getInjectionTargets();
        if (injectionTargets == null || injectionTargets.isEmpty()) {
            return null;
        }
        InjectionTarget injectionTarget = (InjectionTarget)injectionTargets.iterator().next();
        AccessibleObject accessibleObject = InjectionTargetUtil.findInjectionTarget(cl, injectionTarget);
        if (accessibleObject instanceof Field) {
            return ((Field)accessibleObject).getType().getName();
        }
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).getParameterTypes()[0].getName();
        }
        return null;
    }
}

