/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.switchboard.javaee.environment.InjectionTarget;

public class InjectionTargetUtil {
    public static AccessibleObject findInjectionTarget(ClassLoader loader, InjectionTarget target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("<injection-target> class: " + target.getTargetClass() + " was not found in deployment");
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("<injection-target> could not be found: " + target.getTargetClass() + "." + target.getTargetName());
    }
}

